/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.util.DateUtil;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;
import java.time.LocalTime;

public class TimeEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<LocalTime, LocalTime> {
    private static final long serialVersionUID = -5464834689859257617L;

    public TimeEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.TIME, LocalTime.class, EnumKeyValueConfigurationDataType.TIME);
    }

    @Override
    public LocalTime validateValue(EnumKeyValueConfigurationSizing<LocalTime> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        LocalTime inputTime = (LocalTime)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<LocalTime> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputTime;
        }
        if (inputTime == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputTime;
            }
            throw new EmptyValueException("Empty value: invalid time, should be at least [" + valueSize.getMinSizeAsString() + "]!");
        }
        if (inputTime.compareTo(minMaxValue.getMin()) < 0) {
            throw new ValidationException("Too small: invalid date of [" + inputValue + "], should be at least [" + valueSize.getMinSizeAsString() + "] (now " + inputValue + ")!", inputValue, inputTime);
        }
        if (inputTime.compareTo(minMaxValue.getMax()) > 0) {
            throw new ValidationException("Too big: invalid date of [" + inputValue + "], should be in range of [" + valueSize.getMinSizeAsString() + ".." + valueSize.getMaxSizeAsString() + "] (now " + inputValue + ")!", inputValue, inputTime);
        }
        return inputTime;
    }

    @Override
    public EnumKeyValueConfigurationSizing<LocalTime> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<LocalTime>();
    }

    @Override
    public LocalTime getMinSize() {
        return LocalTime.MIN;
    }

    @Override
    public LocalTime getMaxSize() {
        return DateUtil.MAX_TIME;
    }

    @Override
    protected boolean isGreaterThan(LocalTime first, LocalTime second) {
        if (first == null) {
            return second != null;
        }
        if (second == null) {
            return false;
        }
        return first.isAfter(second);
    }
}

