/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;

public class NumberEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<Long, Number> {
    private static final long serialVersionUID = -8613240212933792109L;

    public NumberEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.NUMBER, Long.class, EnumKeyValueConfigurationDataType.NUMBER);
    }

    @Override
    public Long validateValue(EnumKeyValueConfigurationSizing<Number> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        Long inputNumber = (Long)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<Number> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputNumber;
        }
        if (inputNumber == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputNumber;
            }
            throw new EmptyValueException("Empty value: invalid size, should be at least [" + valueSize.getMinSizeAsString() + "]!");
        }
        if (inputNumber.compareTo(minMaxValue.getMin().longValue()) < 0) {
            throw new ValidationException("Too small: invalid size of [" + inputValue + "], should be at least [" + valueSize.getMinSizeAsString() + "] (now " + inputValue + ")!", inputValue, inputNumber);
        }
        if (inputNumber.compareTo(minMaxValue.getMax().longValue()) > 0) {
            throw new ValidationException("Too big: invalid size of [" + inputValue + "], should be in range of [" + valueSize.getMinSizeAsString() + ".." + valueSize.getMaxSizeAsString() + "] (now " + inputValue + ")!", inputValue, inputNumber);
        }
        return inputNumber;
    }

    @Override
    public EnumKeyValueConfigurationSizing<Number> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<Number>();
    }

    @Override
    public Long getMinSize() {
        return 0L;
    }

    @Override
    public Long getMaxSize() {
        return Long.MAX_VALUE;
    }

    @Override
    protected boolean isGreaterThan(Number first, Number second) {
        return this.isGreaterThanValue(first, second);
    }
}

