/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;

public class BooleanEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<Boolean, Boolean> {
    private static final long serialVersionUID = 3112713117065033536L;

    public BooleanEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.BOOLEAN, Boolean.class, EnumKeyValueConfigurationDataType.BOOLEAN);
    }

    @Override
    public Boolean validateValue(EnumKeyValueConfigurationSizing<Boolean> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        Boolean inputBoolean = (Boolean)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<Boolean> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputBoolean;
        }
        if (inputBoolean == null) {
            throw new EmptyValueException("Empty value: invalid boolean [" + inputValue + "]!");
        }
        return inputBoolean;
    }

    @Override
    public EnumKeyValueConfigurationSizing<Boolean> createEnumKeyValueConfigurationSizing() {
        return null;
    }

    @Override
    public Boolean getMinSize() {
        return null;
    }

    @Override
    public Boolean getMaxSize() {
        return null;
    }

    @Override
    protected boolean isGreaterThan(Boolean first, Boolean second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        return first.compareTo(second) > 0;
    }
}

