/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.dto.IEnumKeyValueConfigurationBinaryObject;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;
import java.util.Base64;

public class BinaryEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<IEnumKeyValueConfigurationBinaryObject, Number> {
    private static final long serialVersionUID = 545511902630603231L;

    public BinaryEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.BINARY, IEnumKeyValueConfigurationBinaryObject.class, EnumKeyValueConfigurationDataType.NUMBER);
    }

    @Override
    public IEnumKeyValueConfigurationBinaryObject validateValue(EnumKeyValueConfigurationSizing<Number> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        IEnumKeyValueConfigurationBinaryObject inputBinaryObject = (IEnumKeyValueConfigurationBinaryObject)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<Number> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputBinaryObject;
        }
        if (inputBinaryObject == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputBinaryObject;
            }
            throw new EmptyValueException("Empty value: invalid binary, should be at the length of [" + valueSize.getMinSizeAsString() + "]!");
        }
        if (inputBinaryObject.getName() != null) {
            // empty if block
        }
        if (inputBinaryObject.getMimetype() != null) {
            // empty if block
        }
        if (inputBinaryObject.getTimestamp() != null) {
            // empty if block
        }
        Long length = 0L;
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(inputBinaryObject.getData().trim());
            if (decodedBytes != null) {
                length = decodedBytes.length;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException("Could not decode file content: " + ex.getMessage() + "\n -> [" + inputValue + "]!", inputValue, null);
        }
        if (this.isGreaterThan(minMaxValue.getMin(), length)) {
            throw new ValidationException("Too small: invalid size of file, should be at least [" + valueSize.getMinSizeAsString() + "] (now " + inputValue + ")!", inputValue, inputBinaryObject);
        }
        if (this.isGreaterThan(length, minMaxValue.getMax())) {
            throw new ValidationException("Too big: invalid size of file, should be in range of [" + valueSize.getMinSizeAsString() + ".." + valueSize.getMaxSizeAsString() + "] (now " + inputValue + ", encoded size: " + length + ")!", inputValue, inputBinaryObject);
        }
        return inputBinaryObject;
    }

    @Override
    public EnumKeyValueConfigurationSizing<Number> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<Number>();
    }

    @Override
    public Long getMinSize() {
        return 0L;
    }

    @Override
    public Long getMaxSize() {
        return Long.MAX_VALUE;
    }

    @Override
    protected boolean isGreaterThan(Number first, Number second) {
        return this.isGreaterThanValue(first, second);
    }
}

