/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.IEnumKeyConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.BinaryEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.BooleanEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.CIDREnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.CertificateEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.ColorEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.CronEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.DateEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.DoubleEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.EmailEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.NumberEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.RegExpEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.StringEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.TimeEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.TimestampEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.URIEnumKeyValueConfigurationValueValidator;
import com.github.toolarium.enumeration.configuration.validation.value.impl.UUIDEnumKeyValueConfigurationValueValidator;

public final class EnumKeyValueConfigurationValueValidatorFactory {
    private EnumKeyValueConfigurationValueValidatorFactory() {
    }

    public static EnumKeyValueConfigurationValueValidatorFactory getInstance() {
        return HOLDER.INSTANCE;
    }

    public IEnumKeyConfigurationValueValidator<?, ?> createEnumKeyValueConfigurationValueValidator(EnumKeyValueConfigurationDataType dataType, String maxValue) {
        try {
            switch (dataType) {
                case NUMBER: {
                    return new NumberEnumKeyValueConfigurationValueValidator();
                }
                case DOUBLE: {
                    return new DoubleEnumKeyValueConfigurationValueValidator();
                }
                case BOOLEAN: {
                    return new BooleanEnumKeyValueConfigurationValueValidator();
                }
                case DATE: {
                    return new DateEnumKeyValueConfigurationValueValidator();
                }
                case TIME: {
                    return new TimeEnumKeyValueConfigurationValueValidator();
                }
                case TIMESTAMP: {
                    return new TimestampEnumKeyValueConfigurationValueValidator();
                }
                case REGEXP: {
                    return new RegExpEnumKeyValueConfigurationValueValidator();
                }
                case UUID: {
                    return new UUIDEnumKeyValueConfigurationValueValidator();
                }
                case URI: {
                    return new URIEnumKeyValueConfigurationValueValidator();
                }
                case CIDR: {
                    return new CIDREnumKeyValueConfigurationValueValidator();
                }
                case EMAIL: {
                    return new EmailEnumKeyValueConfigurationValueValidator();
                }
                case CRON: {
                    return new CronEnumKeyValueConfigurationValueValidator();
                }
                case COLOR: {
                    return new ColorEnumKeyValueConfigurationValueValidator();
                }
                case CERTIFICATE: {
                    return new CertificateEnumKeyValueConfigurationValueValidator();
                }
                case BINARY: {
                    return new BinaryEnumKeyValueConfigurationValueValidator();
                }
            }
            return new StringEnumKeyValueConfigurationValueValidator();
        }
        catch (Exception e) {
            return null;
        }
    }

    public <D, T> EnumKeyValueConfigurationSizing<T> createEnumKeyValueConfigurationSizing(EnumKeyValueConfigurationDataType dataType, String minValue, String maxValue) throws ValidationException {
        IEnumKeyConfigurationValueValidator<?, ?> type = EnumKeyValueConfigurationValueValidatorFactory.getInstance().createEnumKeyValueConfigurationValueValidator(dataType, maxValue);
        EnumKeyValueConfigurationSizing<?> result = type.createValueSize(minValue, maxValue);
        return result;
    }

    private static class HOLDER {
        static final EnumKeyValueConfigurationValueValidatorFactory INSTANCE = new EnumKeyValueConfigurationValueValidatorFactory();

        private HOLDER() {
        }
    }
}

