/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation;

import java.util.Arrays;
import java.util.Collection;

public class ValidationException
extends Exception {
    private static final long serialVersionUID = 2462346085465724118L;
    private String configurationValue;
    private Collection<Object> convertedValueList;

    public ValidationException(String message) {
        super(message);
        this.convertedValueList = null;
    }

    public ValidationException(String message, String configurationValue, Object convertedValue) {
        super(message);
        this.configurationValue = configurationValue;
        if (convertedValue != null) {
            this.convertedValueList = Collection.class.isAssignableFrom(convertedValue.getClass()) ? (Collection<Object>)convertedValue : Arrays.asList(convertedValue);
        }
    }

    public ValidationException(String message, String configurationValue, Collection<Object> convertedValueList) {
        super(message);
        this.configurationValue = configurationValue;
        this.convertedValueList = convertedValueList;
    }

    public ValidationException(String message, Exception e) {
        super(message, e);
    }

    public String getConfigurationValue() {
        return this.configurationValue;
    }

    public Collection<Object> getConvertedValueList() {
        return this.convertedValueList;
    }

    public void setValue(String configurationValue, Collection<Object> convertedValueList) {
        this.configurationValue = configurationValue;
        this.convertedValueList = convertedValueList;
    }
}

