/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionUtil {
    private volatile boolean defaultDisabledAccessWarnings = false;
    private volatile boolean disabledAccessWarnings = false;

    private ReflectionUtil() {
        String prop = System.getProperty("disabledAccessWarnings");
        if (prop != null && prop.trim().equalsIgnoreCase("true")) {
            this.defaultDisabledAccessWarnings = true;
        }
    }

    public static ReflectionUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public <T> T newInstance(Class<T> clazz) throws SecurityException, InstantiationException, IllegalAccessException {
        if (clazz == null) {
            throw new InstantiationException("Invalid empty class!");
        }
        try {
            this.disableAccessWarnings();
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            InstantiationException ex = new InstantiationException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public void disableAccessWarnings() {
        if (this.defaultDisabledAccessWarnings == this.disabledAccessWarnings) {
            return;
        }
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
            this.disabledAccessWarnings = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class HOLDER {
        static final ReflectionUtil INSTANCE = new ReflectionUtil();

        private HOLDER() {
        }
    }
}

