/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class JSONUtil {
    private ObjectMapper objectMapper;

    private JSONUtil() {
    }

    public static JSONUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public <T> T read(Class<T> type, InputStream inputstream) throws IOException {
        if (inputstream == null) {
            return null;
        }
        try {
            return (T)this.getMapper().readValue(inputstream, type);
        }
        catch (JsonParseException | JsonMappingException e) {
            String msg = e.getMessage();
            if (msg != null && msg.startsWith("No content")) {
                return null;
            }
            IOException ex = new IOException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public <T> void write(T type, OutputStream outputStream) throws IOException {
        if (outputStream == null || type == null) {
            return;
        }
        try {
            this.getMapper().writerWithDefaultPrettyPrinter().writeValue(outputStream, type);
        }
        catch (JsonParseException | JsonMappingException e) {
            IOException ex = new IOException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public String convert(Collection<String> inputList) throws IllegalArgumentException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : inputList) {
                if (str == null) continue;
                list.add(str);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.write(list, outputStream);
            return outputStream.toString();
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public List<String> convert(String inputJson) throws IllegalArgumentException {
        if (inputJson == null || inputJson.isBlank()) {
            return Collections.emptyList();
        }
        try {
            String json = inputJson.trim();
            if (!json.startsWith("[") && !json.endsWith("]")) {
                return Arrays.asList(inputJson);
            }
            String[] elements = (String[])this.getMapper().readValue(inputJson, String[].class);
            if (elements != null && elements.length > 0) {
                return Arrays.asList(elements);
            }
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        return Collections.emptyList();
    }

    private ObjectMapper getMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.registerModule((Module)new JavaTimeModule());
            this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.objectMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        return this.objectMapper;
    }

    private static class HOLDER {
        static final JSONUtil INSTANCE = new JSONUtil();

        private HOLDER() {
        }
    }
}

