/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static ExceptionUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public String prepareExceptionWithStacktraceInMessage(Exception ex) {
        return this.prepareStacktraceInMessage(ex, "com.github.toolarium.enumeration.configuration");
    }

    public String prepareStacktraceInMessage(Exception ex, String filterPackage) {
        if (ex == null) {
            return "";
        }
        String msg = ex.getMessage() + "\n" + ex.getClass().getName() + ":";
        StackTraceElement[] occurence = ex.getStackTrace();
        if (occurence != null) {
            for (int i = 0; i < occurence.length; ++i) {
                String element = occurence[i].toString();
                if (!element.startsWith(filterPackage)) continue;
                msg = msg + "\n  at " + element;
            }
        }
        return msg;
    }

    public <E extends Exception> E throwExceptionWithStacktraceInMessage(Exception ex, Class<E> exceptionClass) {
        if (ex == null) {
            return this.throwsException(exceptionClass, "Invalid exception!");
        }
        return this.throwExceptionWithStacktraceInMessage(ex, exceptionClass, "com.github.toolarium.enumeration.configuration");
    }

    public <E extends Exception> E throwExceptionWithStacktraceInMessage(Exception ex, Class<E> exceptionClass, String filterPackage) {
        if (ex == null) {
            return this.throwsException(exceptionClass, "Invalid exception!");
        }
        return this.throwsException(exceptionClass, this.prepareStacktraceInMessage(ex, filterPackage), ex.getStackTrace());
    }

    public <E extends Exception> E throwsException(Exception ex, Class<E> exceptionClass, boolean withStacktrace) {
        if (ex == null) {
            return this.throwsException(exceptionClass, "Invalid exception!", null);
        }
        if (withStacktrace) {
            return this.throwsException(exceptionClass, ex.getMessage(), ex.getStackTrace());
        }
        return this.throwsException(exceptionClass, ex.getMessage());
    }

    public <E extends Exception> E throwsException(Class<E> exceptionClass, String message) {
        return this.throwsException(exceptionClass, message, null);
    }

    public <E extends Exception> E throwsException(Class<E> exceptionClass, String message, StackTraceElement[] stackTraceElement) {
        String msg = "";
        if (message != null) {
            msg = message;
        }
        if (exceptionClass == null) {
            throw new IllegalArgumentException("Invalid exception parameter, missing exception type!");
        }
        Constructor<E> constructor = null;
        try {
            constructor = exceptionClass.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Could not found constructor for exception " + exceptionClass + ": " + ex.getMessage() + " for [" + msg + "]");
            ex.setStackTrace(e.getStackTrace());
            throw e;
        }
        Exception exception = null;
        try {
            exception = (Exception)constructor.newInstance(msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Could not instantiate exception " + exceptionClass + ": " + ex.getMessage() + " for [" + msg + "]");
            e.setStackTrace(e.getStackTrace());
            throw e;
        }
        if (stackTraceElement != null && stackTraceElement.length > 0) {
            exception.setStackTrace(stackTraceElement);
        }
        return (E)exception;
    }

    private static class HOLDER {
        static final ExceptionUtil INSTANCE = new ExceptionUtil();

        private HOLDER() {
        }
    }
}

