/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import com.github.toolarium.enumeration.configuration.annotation.EnumConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.util.AnnotationConvertUtil;
import java.lang.reflect.Field;

public final class EnumUtil {
    private EnumUtil() {
    }

    public static EnumUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public <T extends Enum<T>> EnumKeyConfiguration getEnumKeyConfigurationAnnotationInformation(T e) throws IllegalArgumentException {
        if (e == null) {
            return null;
        }
        try {
            Field field = e.getClass().getField(e.name());
            EnumKeyConfiguration enumKeyConfiguration = AnnotationConvertUtil.getInstance().convert(field.getAnnotation(com.github.toolarium.enumeration.configuration.annotation.EnumKeyConfiguration.class));
            if (enumKeyConfiguration == null) {
                return null;
            }
            enumKeyConfiguration.setKey(e.name());
            com.github.toolarium.enumeration.configuration.dto.EnumConfiguration<EnumKeyConfiguration> enumConfiguration = AnnotationConvertUtil.getInstance().convert(e.getClass().getAnnotation(EnumConfiguration.class));
            if (enumConfiguration != null) {
                enumKeyConfiguration = enumConfiguration.add(enumKeyConfiguration);
            }
            return enumKeyConfiguration;
        }
        catch (Exception ex) {
            IllegalArgumentException ie = new IllegalArgumentException("Could not find annotation: " + ex.getMessage());
            ie.setStackTrace(ex.getStackTrace());
            throw ie;
        }
    }

    public EnumKeyValueConfiguration getEnumKeyValueConfigurationAnnotationInformation(Enum<?> e) throws IllegalArgumentException {
        if (e == null) {
            return null;
        }
        try {
            Field field = e.getClass().getField(e.name());
            EnumKeyValueConfiguration enumKeyValueConfiguration = AnnotationConvertUtil.getInstance().convert(field.getAnnotation(com.github.toolarium.enumeration.configuration.annotation.EnumKeyValueConfiguration.class));
            if (enumKeyValueConfiguration == null) {
                return null;
            }
            enumKeyValueConfiguration.setKey(e.name());
            com.github.toolarium.enumeration.configuration.dto.EnumConfiguration<EnumKeyValueConfiguration> enumConfiguration = AnnotationConvertUtil.getInstance().convert(e.getClass().getAnnotation(EnumConfiguration.class));
            if (enumConfiguration != null) {
                enumKeyValueConfiguration = enumConfiguration.add(enumKeyValueConfiguration);
            }
            return enumKeyValueConfiguration;
        }
        catch (Exception ex) {
            IllegalArgumentException ie = new IllegalArgumentException("Could not find annotation: " + ex.getMessage());
            ie.setStackTrace(ex.getStackTrace());
            throw ie;
        }
    }

    public <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Enum[] types = (Enum[])enumType.getEnumConstants();
        String nameToParse = name.trim();
        for (int i = 0; i < types.length; ++i) {
            Enum type = types[i];
            if (!type.name().equalsIgnoreCase(nameToParse)) continue;
            return (T)type;
        }
        return null;
    }

    public <T extends Enum<T>> T mapEnum(Class<T> enumType, Enum<?> inputEnum) {
        if (inputEnum == null) {
            return null;
        }
        return this.valueOf(enumType, inputEnum.name());
    }

    private static class HOLDER {
        static final EnumUtil INSTANCE = new EnumUtil();

        private HOLDER() {
        }
    }
}

