/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import com.github.toolarium.enumeration.configuration.converter.StringTypeConverterFactory;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationBinaryObject;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.IEnumKeyValueConfigurationBinaryObject;
import com.github.toolarium.enumeration.configuration.store.exception.EnumConfigurationStoreException;
import com.github.toolarium.enumeration.configuration.util.DateUtil;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public final class EnumKeyValueConfigurationBinaryObjectParser {
    public static final String SEPARATOR = "|";
    public static final String BRACE_START = "{";
    public static final String BRACE_END = "}";
    private static final String ESCAPED_SEPARATOR = "\\|";

    private EnumKeyValueConfigurationBinaryObjectParser() {
    }

    public static EnumKeyValueConfigurationBinaryObjectParser getInstance() {
        return HOLDER.INSTANCE;
    }

    public IEnumKeyValueConfigurationBinaryObject parse(String input) throws DateTimeParseException {
        EnumKeyValueConfigurationBinaryObject enumKeyValueConfigurationBinaryObject = new EnumKeyValueConfigurationBinaryObject();
        if (input == null || input.isEmpty()) {
            return enumKeyValueConfigurationBinaryObject;
        }
        String[] binaryData = input.trim().split(ESCAPED_SEPARATOR);
        if (binaryData.length <= 1) {
            this.parseContent(enumKeyValueConfigurationBinaryObject, binaryData[0]);
        } else if (binaryData.length == 2) {
            String s = binaryData[0].trim();
            Instant timestamp = this.parseTimestamp(s.trim());
            if (timestamp != null) {
                enumKeyValueConfigurationBinaryObject.setTimestamp(timestamp);
            } else {
                enumKeyValueConfigurationBinaryObject.setName(s.trim());
            }
            this.parseContent(enumKeyValueConfigurationBinaryObject, binaryData[1]);
        } else {
            enumKeyValueConfigurationBinaryObject.setName(binaryData[0].trim());
            enumKeyValueConfigurationBinaryObject.setTimestamp(this.parseTimestamp(binaryData[1].trim()));
            this.parseContent(enumKeyValueConfigurationBinaryObject, binaryData[binaryData.length - 1]);
        }
        return enumKeyValueConfigurationBinaryObject;
    }

    public String format(IEnumKeyValueConfigurationBinaryObject enumKeyValueConfigurationBinaryObject) {
        StringBuilder builder = new StringBuilder();
        if (enumKeyValueConfigurationBinaryObject.getName() != null && !enumKeyValueConfigurationBinaryObject.getName().isBlank()) {
            builder.append(enumKeyValueConfigurationBinaryObject.getName());
            builder.append(SEPARATOR);
        }
        if (enumKeyValueConfigurationBinaryObject.getTimestamp() != null) {
            builder.append(enumKeyValueConfigurationBinaryObject.getTimestamp());
        } else {
            builder.append(Instant.now());
        }
        builder.append(SEPARATOR);
        if (enumKeyValueConfigurationBinaryObject.getMimetype() != null && !enumKeyValueConfigurationBinaryObject.getMimetype().isBlank()) {
            builder.append(BRACE_START);
            builder.append(enumKeyValueConfigurationBinaryObject.getMimetype());
            builder.append(BRACE_END);
        }
        if (enumKeyValueConfigurationBinaryObject.getData() != null && !enumKeyValueConfigurationBinaryObject.getData().isBlank()) {
            builder.append(enumKeyValueConfigurationBinaryObject.getData());
        }
        return builder.toString();
    }

    public String mergeDefaultValues(EnumKeyValueConfiguration enumKeyValueConfiguration, String inputValue) {
        String value = inputValue;
        if (enumKeyValueConfiguration != null && EnumKeyValueConfigurationDataType.BINARY.equals(enumKeyValueConfiguration.getDataType()) && enumKeyValueConfiguration.getDefaultValue() != null) {
            try {
                IEnumKeyValueConfigurationBinaryObject valueData;
                if (!enumKeyValueConfiguration.getDefaultValue().equals(value) && (valueData = (IEnumKeyValueConfigurationBinaryObject)StringTypeConverterFactory.getInstance().getStringTypeConverter().convert(enumKeyValueConfiguration.getDataType(), value)) != null) {
                    IEnumKeyValueConfigurationBinaryObject defaultValueData = (IEnumKeyValueConfigurationBinaryObject)StringTypeConverterFactory.getInstance().getStringTypeConverter().convert(enumKeyValueConfiguration.getDataType(), enumKeyValueConfiguration.getDefaultValue());
                    if (defaultValueData != null) {
                        EnumKeyValueConfigurationBinaryObject mergedValueData = new EnumKeyValueConfigurationBinaryObject(defaultValueData);
                        mergedValueData.merge(valueData);
                        value = this.format(mergedValueData);
                    } else {
                        value = this.format(valueData);
                    }
                }
            }
            catch (ValidationException ex) {
                String configurationKeyName = enumKeyValueConfiguration.getKey();
                EnumConfigurationStoreException e = new EnumConfigurationStoreException("Invalid configuration found for key [" + configurationKeyName + "]: " + ex.getMessage(), ex);
                e.add(configurationKeyName, value, ex.getConvertedValueList());
                throw e;
            }
        }
        return value;
    }

    private void parseContent(EnumKeyValueConfigurationBinaryObject enumKeyValueConfigurationBinaryObject, String inputContent) {
        int idx;
        if (inputContent == null || inputContent.isBlank()) {
            return;
        }
        String content = inputContent.trim();
        if (content.startsWith(BRACE_START) && (idx = content.indexOf(BRACE_END)) > 0) {
            enumKeyValueConfigurationBinaryObject.setMimetype(content.substring(1, idx).trim());
            content = content.length() > idx ? content.substring(idx + 1).trim() : null;
        }
        enumKeyValueConfigurationBinaryObject.setData(content);
    }

    private Instant parseTimestamp(String inputTimestamp) throws DateTimeParseException {
        String[] simpleTime;
        if (inputTimestamp == null) {
            return null;
        }
        String[] timestampSplit = inputTimestamp.trim().split("T");
        if (timestampSplit.length == 0) {
            return null;
        }
        if (!this.isNumber(timestampSplit[0].split("-"))) {
            return null;
        }
        if (timestampSplit.length > 1 && (simpleTime = timestampSplit[1].split("\\.")) != null && simpleTime.length > 0 && !this.isNumber(simpleTime[0].split(":"))) {
            return null;
        }
        return DateUtil.getInstance().parseTimestamp(inputTimestamp);
    }

    private boolean isNumber(String[] values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (this.isNumber(values[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isNumber(String value) {
        if (value == null || value.isBlank()) {
            return false;
        }
        try {
            Integer.valueOf(value.trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static class HOLDER {
        static final EnumKeyValueConfigurationBinaryObjectParser INSTANCE = new EnumKeyValueConfigurationBinaryObjectParser();

        private HOLDER() {
        }
    }
}

