/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassPathUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathUtil.class);

    private ClassPathUtil() {
    }

    public static ClassPathUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public List<Class<?>> search(String inputClassName, boolean ignoreCase) {
        ArrayList result = new ArrayList();
        if (inputClassName == null || inputClassName.isBlank()) {
            return result;
        }
        String className = inputClassName.trim();
        int idx = className.lastIndexOf(46);
        if (idx <= 0) {
            return result;
        }
        String packageName = className.substring(0, idx);
        String classToSearch = className;
        for (Class<?> clazz : this.getClassOfPackage(packageName)) {
            if (ignoreCase) {
                if (!classToSearch.equalsIgnoreCase(clazz.getName())) continue;
                result.add(clazz);
                continue;
            }
            if (!classToSearch.equals(clazz.getName())) continue;
            result.add(clazz);
        }
        return result;
    }

    protected List<Class<?>> getClassOfPackage(String packageName) {
        ArrayList classes = new ArrayList();
        for (String directory : this.selectResourcesFromClassLoader(packageName, Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader())) {
            classes.addAll(ClassPathUtil.findClasses(new File(directory), packageName));
        }
        return classes;
    }

    private List<String> selectResourcesFromClassLoader(String packageName, ClassLoader ... classLoaders) {
        ArrayList<String> dirs = new ArrayList<String>();
        for (ClassLoader cl : classLoaders) {
            try {
                Enumeration<URL> resources = cl.getResources(packageName.replace('.', '/'));
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    dirs.add(resource.getFile());
                }
            }
            catch (IOException e) {
                LOG.warn("Could not read path: " + packageName + ": " + e.getMessage());
            }
        }
        return dirs;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ClassPathUtil.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            ClassPathUtil.loadClass(classes, className);
        }
        return classes;
    }

    private static void loadClass(List<Class<?>> classes, String className) {
        try {
            classes.add(Class.forName(className));
            return;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError throwable) {
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(className));
                return;
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError throwable2) {
                try {
                    classes.add(ClassLoader.getSystemClassLoader().loadClass(className));
                    return;
                }
                catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError throwable3) {
                    return;
                }
            }
        }
    }

    private static class HOLDER {
        static final ClassPathUtil INSTANCE = new ClassPathUtil();

        private HOLDER() {
        }
    }
}

