/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import java.util.Base64;
import java.util.regex.Pattern;

public final class Base64Util {
    private static final Pattern BASE64_PATTERN = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");

    private Base64Util() {
    }

    public static Base64Util getInstance() {
        return HOLDER.INSTANCE;
    }

    public boolean isValidBase64(String input) {
        if (input == null || input.isBlank()) {
            return false;
        }
        String base64Content = input.trim();
        if (BASE64_PATTERN.matcher(base64Content).matches()) {
            try {
                Base64.getDecoder().decode(base64Content);
                return base64Content.length() % 4 == 0;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    private static class HOLDER {
        static final Base64Util INSTANCE = new Base64Util();

        private HOLDER() {
        }
    }
}

