/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.store.impl;

import com.github.toolarium.enumeration.configuration.dto.SortedProperties;
import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationResourceResolver;
import com.github.toolarium.enumeration.configuration.store.exception.EnumConfigurationStoreException;
import com.github.toolarium.enumeration.configuration.store.impl.AbstractBaseTypeEnumConfigurationStore;
import com.github.toolarium.enumeration.configuration.store.impl.EnumConfigurationKeyResolver;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesEnumConfigurationStore
extends AbstractBaseTypeEnumConfigurationStore {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesEnumConfigurationStore.class);
    private Set<String> keySet = new HashSet<String>();
    private Properties properties = new Properties();

    public PropertiesEnumConfigurationStore() {
    }

    public PropertiesEnumConfigurationStore(IEnumConfigurationResourceResolver enumConfigurationResourceResolver) {
        this();
        this.setEnumConfigurationKeyResolver(new EnumConfigurationKeyResolver(enumConfigurationResourceResolver, true));
    }

    public Properties getProperties() {
        return new SortedProperties((Properties)this.properties.clone());
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        HashSet<String> result = new HashSet<String>();
        for (Object key : properties.keySet()) {
            result.add("" + key);
        }
        this.keySet = result;
    }

    @Override
    protected String loadConfiguration(String configurationKeyName) throws EnumConfigurationStoreException {
        if (configurationKeyName == null || configurationKeyName.isBlank()) {
            return null;
        }
        return this.properties.getProperty(configurationKeyName);
    }

    @Override
    protected <D> void writeConfiguration(String configurationKeyName, String configurationValue) throws EnumConfigurationStoreException {
        if (configurationKeyName != null && !configurationKeyName.isBlank()) {
            LOG.debug("Write [" + configurationKeyName + "]");
            if (!this.keySet.contains(configurationKeyName)) {
                this.keySet.add(configurationKeyName);
            }
            this.properties.setProperty(configurationKeyName, configurationValue);
        }
    }

    @Override
    protected <D> String deleteConfiguration(String configurationKeyName) throws EnumConfigurationStoreException {
        if (configurationKeyName == null || configurationKeyName.isBlank()) {
            return null;
        }
        LOG.debug("Delete [" + configurationKeyName + "]");
        String value = this.loadConfiguration(configurationKeyName);
        this.properties.remove(configurationKeyName);
        if (this.keySet.contains(configurationKeyName)) {
            this.keySet.remove(configurationKeyName);
        }
        return value;
    }

    @Override
    protected Set<String> readKeys() throws EnumConfigurationStoreException {
        return new TreeSet<String>(this.keySet);
    }
}

