/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.store.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumConfigurations;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.resource.EnumConfigurationResourceFactory;
import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationKeyResolver;
import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationResourceResolver;
import com.github.toolarium.enumeration.configuration.store.exception.EnumConfigurationStoreException;
import com.github.toolarium.enumeration.configuration.util.ClassPathUtil;
import com.github.toolarium.enumeration.configuration.util.EnumUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumConfigurationKeyResolver
implements IEnumConfigurationKeyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EnumConfigurationKeyResolver.class);
    private static final String CONFIGURATION_KEY_SEPARATOR = "#";
    private Map<Object, String> configurationKeyMap = new ConcurrentHashMap<Object, String>();
    private Map<String, Object> configurationKeyNameMap = new ConcurrentHashMap<String, Object>();
    private Map<String, EnumConfigurations> loadedEnumConfigurationsMap = new ConcurrentHashMap<String, EnumConfigurations>();
    private IEnumConfigurationResourceResolver enumConfigurationResourceResolver;
    private boolean ignoreCase;

    public EnumConfigurationKeyResolver() {
        this(null, true);
    }

    public EnumConfigurationKeyResolver(IEnumConfigurationResourceResolver enumConfigurationResourceResolver) {
        this(enumConfigurationResourceResolver, true);
    }

    public EnumConfigurationKeyResolver(IEnumConfigurationResourceResolver enumConfigurationResourceResolver, boolean ignoreCase) {
        this.enumConfigurationResourceResolver = enumConfigurationResourceResolver;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String createConfigurationKeyName(String configurationName, String keyName) {
        if (configurationName == null || configurationName.isBlank()) {
            return null;
        }
        if (keyName == null || keyName.isBlank()) {
            return null;
        }
        return (configurationName + this.getConfigurationKeySeparator() + keyName).toLowerCase();
    }

    @Override
    public <T extends Enum<T>> String resolveConfigurationKeyName(T configurationKey) {
        if (configurationKey == null) {
            throw new EnumConfigurationStoreException("Invalid configuration key!");
        }
        String configurationKeyName = this.configurationKeyMap.get(configurationKey);
        if (configurationKeyName == null) {
            configurationKeyName = this.convertToConfigurationKeyName(configurationKey);
            if (configurationKeyName == null) {
                return null;
            }
            this.configurationKeyMap.put(configurationKey, configurationKeyName);
            this.configurationKeyNameMap.put(configurationKeyName, configurationKey);
        }
        return configurationKeyName;
    }

    @Override
    public <T extends Enum<T>> T resolveConfigurationKey(String configurationKeyName) {
        if (configurationKeyName == null || configurationKeyName.isBlank()) {
            throw new EnumConfigurationStoreException("Invalid configuration name!");
        }
        Enum configurationKey = (Enum)this.configurationKeyNameMap.get(configurationKeyName);
        if (configurationKey == null) {
            configurationKey = this.convertToConfigurationKey(configurationKeyName);
            if (configurationKey == null) {
                return null;
            }
            this.configurationKeyMap.put(configurationKey, configurationKeyName);
            this.configurationKeyNameMap.put(configurationKeyName, configurationKey);
        }
        return (T)configurationKey;
    }

    @Override
    public EnumKeyValueConfiguration getEnumKeyValueConfiguration(String inputConfigurationKeyName) throws EnumConfigurationStoreException {
        if (inputConfigurationKeyName == null) {
            LOG.debug("Invalid input configuration key name!");
            return null;
        }
        String configurationKeyName = inputConfigurationKeyName;
        String[] configurationKeyNameSplit = this.splitKeyName(configurationKeyName);
        if (configurationKeyNameSplit == null || configurationKeyNameSplit.length < 2) {
            return null;
        }
        EnumConfigurations loadedEnumConfigurations = this.loadedEnumConfigurationsMap.get(configurationKeyNameSplit[0]);
        if (loadedEnumConfigurations == null) {
            LOG.debug("Try to resolve configuration key [" + configurationKeyNameSplit[0] + "]...");
            if (this.enumConfigurationResourceResolver == null) {
                throw new EnumConfigurationStoreException("Not supported resource input stream!");
            }
            InputStream enumConfigurationResourceInputStream = this.enumConfigurationResourceResolver.getEnumConfigurationResourceStream(configurationKeyNameSplit[0], this.ignoreCase);
            if (enumConfigurationResourceInputStream != null) {
                LOG.debug("Load enum configuration information for key [" + configurationKeyNameSplit[0] + "]...");
                try {
                    loadedEnumConfigurations = EnumConfigurationResourceFactory.getInstance().load(enumConfigurationResourceInputStream);
                    if (loadedEnumConfigurations != null) {
                        LOG.info("Successful load enum configuration [" + loadedEnumConfigurations.getName() + " v" + loadedEnumConfigurations.getVersion() + "].");
                        this.loadedEnumConfigurationsMap.put(configurationKeyNameSplit[0], loadedEnumConfigurations);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Loaded enum configuration information: " + loadedEnumConfigurations);
                        }
                    } else {
                        LOG.warn("Could not load enum configuration information for key [" + configurationKeyNameSplit[0] + "]!");
                    }
                    try {
                        enumConfigurationResourceInputStream.close();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (IOException ioex) {
                    LOG.warn("Could not load enum configuration information for key [" + configurationKeyNameSplit[0] + "], invalid content:\n" + ioex.getMessage());
                }
            }
        } else {
            LOG.debug("Found configuration " + configurationKeyNameSplit[0] + "] in cache.");
        }
        EnumKeyValueConfiguration enumKeyValueConfiguration = null;
        if (loadedEnumConfigurations != null) {
            LOG.debug("Select configuration [" + configurationKeyNameSplit[0] + "]...");
            EnumConfiguration<? extends EnumKeyConfiguration> loadedEnumConfiguration = null;
            if (this.ignoreCase) {
                Set<EnumConfiguration<? extends EnumKeyConfiguration>> set = loadedEnumConfigurations.getEnumConfigurationList();
                if (set != null) {
                    for (EnumConfiguration<? extends EnumKeyConfiguration> e : set) {
                        if (!e.getName().equalsIgnoreCase(configurationKeyNameSplit[0])) continue;
                        LOG.debug("Configuration key [" + configurationKeyName + "] found (" + e.getName() + ").");
                        loadedEnumConfiguration = e;
                        break;
                    }
                }
            } else {
                loadedEnumConfiguration = loadedEnumConfigurations.get(configurationKeyNameSplit[0]);
                if (loadedEnumConfiguration != null) {
                    LOG.debug("Configuration key [" + configurationKeyName + "] found.");
                }
            }
            if (loadedEnumConfiguration != null) {
                for (EnumKeyValueConfiguration enumKeyValueConfiguration2 : loadedEnumConfiguration.getKeyList()) {
                    if ((!this.ignoreCase || !configurationKeyNameSplit[1].equalsIgnoreCase(enumKeyValueConfiguration2.getKey())) && (this.ignoreCase || !configurationKeyNameSplit[1].equals(enumKeyValueConfiguration2.getKey()))) continue;
                    LOG.debug("Resolved enum configuration for key [" + configurationKeyName + "].");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved enum configuration for key [" + configurationKeyName + "]: " + loadedEnumConfiguration);
                    }
                    enumKeyValueConfiguration = enumKeyValueConfiguration2;
                    break;
                }
            }
            if (enumKeyValueConfiguration == null) {
                LOG.warn("Could not resolve enum configuration for key [" + configurationKeyName + "]!");
            }
        }
        return enumKeyValueConfiguration;
    }

    public void clearCache() {
        this.configurationKeyMap.clear();
        this.configurationKeyNameMap.clear();
        this.loadedEnumConfigurationsMap.clear();
    }

    protected <T extends Enum<T>> T convertToConfigurationKey(String configurationKeyName) {
        if (configurationKeyName == null || configurationKeyName.isBlank()) {
            return null;
        }
        String[] split = this.splitKeyName(configurationKeyName);
        if (split == null || split[0] == null || split[1] == null) {
            return null;
        }
        String className = split[0].trim();
        String enumName = split[1].trim();
        List<Class<?>> classes = ClassPathUtil.getInstance().search(className, true);
        if (classes != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                Object t = EnumUtil.getInstance().valueOf(clazz, enumName);
                if (t == null) continue;
                return (T)t;
            }
        }
        return null;
    }

    protected <T extends Enum<T>> String convertToConfigurationKeyName(T configurationKey) {
        return this.createConfigurationKeyName(configurationKey.getClass().getName().toLowerCase(), configurationKey.name().toLowerCase());
    }

    protected String[] splitKeyName(String inputConfigurationKeyName) {
        if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) {
            return null;
        }
        String configurationKeyName = inputConfigurationKeyName.trim();
        String[] split = configurationKeyName.split(this.getConfigurationKeySeparator());
        if (split.length < 2) {
            return null;
        }
        split[0] = split[0].trim();
        split[1] = split[1].trim();
        return split;
    }

    protected String getConfigurationKeySeparator() {
        return CONFIGURATION_KEY_SEPARATOR;
    }
}

