/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.store.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.dto.SortedProperties;
import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationValue;
import com.github.toolarium.enumeration.configuration.store.exception.EnumConfigurationStoreException;
import com.github.toolarium.enumeration.configuration.store.impl.AbstractBaseEnumConfigurationStore;
import com.github.toolarium.enumeration.configuration.util.EnumUtil;
import com.github.toolarium.enumeration.configuration.validation.EnumKeyConfigurationValidatorFactory;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseTypeEnumConfigurationStore
extends AbstractBaseEnumConfigurationStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBaseTypeEnumConfigurationStore.class);
    private Map<Object, EnumKeyValueConfiguration> enumKeyValueConfigurationMap = new ConcurrentHashMap<Object, EnumKeyValueConfiguration>();

    @Override
    public <D, T extends Enum<T>> IEnumConfigurationValue<D> readConfigurationValue(T configurationKey) throws EnumConfigurationStoreException {
        return this.readConfigurationValue(configurationKey, true);
    }

    protected <D, T extends Enum<T>> IEnumConfigurationValue<D> readConfigurationValue(T configurationKey, boolean supportReturnDefaultValueIfMissing) throws EnumConfigurationStoreException {
        if (configurationKey == null) {
            LOG.debug("Invalid input configuration key!");
            return null;
        }
        String configurationKeyName = this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey);
        String value = this.prepareValue(this.getEnumKeyValueConfiguration(configurationKey), this.loadConfiguration(configurationKeyName), supportReturnDefaultValueIfMissing);
        IEnumConfigurationValue<D> result = null;
        if (value != null) {
            result = this.validate(configurationKey, value);
        }
        return result;
    }

    @Override
    public <D, T extends Enum<T>> IEnumConfigurationValue<D> readConfigurationValueIgnoreDefault(T configurationKey) throws EnumConfigurationStoreException {
        return this.readConfigurationValue(configurationKey, false);
    }

    @Override
    public <T extends Enum<T>> Properties readConfigurationValueList(T[] configurationKeys) throws EnumConfigurationStoreException {
        SortedProperties result = new SortedProperties();
        if (configurationKeys == null || configurationKeys.length == 0) {
            LOG.debug("Invalid input configuration keys!");
            return result;
        }
        for (T configurationKey : configurationKeys) {
            String configurationKeyName = this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey);
            IEnumConfigurationValue value = this.readConfigurationValue(configurationKey);
            result.setProperty(configurationKeyName, this.handlingNullObject(value));
        }
        return result;
    }

    @Override
    public <T extends Enum<T>> Properties readConfigurationValueListIgnoreDefault(T[] configurationKeys) throws EnumConfigurationStoreException {
        SortedProperties result = new SortedProperties();
        if (configurationKeys == null || configurationKeys.length == 0) {
            LOG.debug("Invalid input configuration keys!");
            return result;
        }
        for (T configurationKey : configurationKeys) {
            String configurationKeyName = this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey);
            IEnumConfigurationValue value = this.readConfigurationValueIgnoreDefault(configurationKey);
            result.setProperty(configurationKeyName, this.handlingNullObject(value));
        }
        return result;
    }

    @Override
    public <D, T extends Enum<T>> void writeConfigurationValue(T configurationKey, String value) throws EnumConfigurationStoreException {
        if (configurationKey == null) {
            LOG.debug("Invalid input configuration key!");
            return;
        }
        IEnumConfigurationValue<D> val = this.validate(configurationKey, value);
        if (val != null) {
            this.writeConfiguration(this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey), val.toString());
        }
    }

    @Override
    public <T extends Enum<T>> void writeConfigurationValue(T configurationKey, Object configurationValue) throws EnumConfigurationStoreException {
        if (configurationKey == null) {
            LOG.debug("Invalid input configuration key!");
            return;
        }
        String configurationKeyName = this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey);
        String value = this.convertObjectToString(configurationKeyName, EnumUtil.getInstance().getEnumKeyValueConfigurationAnnotationInformation(configurationKey), configurationValue);
        this.validate(configurationKey, value);
        this.writeConfiguration(configurationKeyName, value);
    }

    @Override
    public <D, T extends Enum<T>> IEnumConfigurationValue<D> deleteConfigurationValue(T configurationKey) throws EnumConfigurationStoreException {
        if (configurationKey == null) {
            LOG.debug("Invalid input configuration key!");
            return null;
        }
        IEnumConfigurationValue<D> result = this.readConfigurationValueIgnoreDefault(configurationKey);
        String configurationKeyName = this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey);
        this.deleteConfiguration(configurationKeyName);
        return result;
    }

    @Override
    public <T extends Enum<T>> Properties deleteConfigurationValueList(T[] configurationKeys) throws EnumConfigurationStoreException {
        SortedProperties result = new SortedProperties();
        if (configurationKeys == null || configurationKeys.length == 0) {
            LOG.debug("Invalid input configuration keys!");
            return result;
        }
        for (T configurationKey : configurationKeys) {
            String configurationKeyName = this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey);
            result.setProperty(configurationKeyName, this.handlingNullObject(this.deleteConfiguration(configurationKeyName)));
        }
        return result;
    }

    protected <D, T extends Enum<T>> IEnumConfigurationValue<D> validate(T configurationKey, String value) throws EnumConfigurationStoreException {
        if (configurationKey == null) {
            throw new EnumConfigurationStoreException("Invalid configuration key!");
        }
        String configurationKeyName = this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey);
        try {
            EnumKeyValueConfiguration enumKeyValueConfiguration = this.getEnumKeyValueConfiguration(configurationKey);
            Collection valueList = EnumKeyConfigurationValidatorFactory.getInstance().getValidator().validate(enumKeyValueConfiguration, value);
            return this.prepareResult(value, valueList);
        }
        catch (ValidationException ex) {
            String msg = "Invalid configuration found for key [" + configurationKeyName + "]: " + ex.getMessage();
            LOG.debug(msg);
            EnumConfigurationStoreException e = new EnumConfigurationStoreException(msg, ex);
            e.add(configurationKeyName, value, ex.getConvertedValueList());
            throw e;
        }
    }

    @Override
    protected EnumKeyValueConfiguration getEnumKeyValueConfiguration(String inputConfigurationKeyName) throws EnumConfigurationStoreException {
        EnumKeyValueConfiguration enumKeyValueConfiguration = this.enumKeyValueConfigurationMap.get(inputConfigurationKeyName);
        if (enumKeyValueConfiguration != null) {
            return enumKeyValueConfiguration;
        }
        return super.getEnumKeyValueConfiguration(inputConfigurationKeyName);
    }

    protected <T extends Enum<T>> EnumKeyValueConfiguration getEnumKeyValueConfiguration(T configurationKey) throws EnumConfigurationStoreException {
        if (configurationKey == null) {
            throw new EnumConfigurationStoreException("Invalid configuration key!");
        }
        String cacheKey = this.getEnumConfigurationKeyResolver().createConfigurationKeyName(configurationKey.getClass().getName(), configurationKey.name());
        EnumKeyValueConfiguration enumKeyValueConfiguration = this.enumKeyValueConfigurationMap.get(cacheKey);
        if (enumKeyValueConfiguration == null) {
            try {
                enumKeyValueConfiguration = EnumUtil.getInstance().getEnumKeyValueConfigurationAnnotationInformation(configurationKey);
                if (enumKeyValueConfiguration != null) {
                    this.enumKeyValueConfigurationMap.put(cacheKey, enumKeyValueConfiguration);
                }
            }
            catch (IllegalArgumentException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not get enum configuration from annotation of key [" + cacheKey + "]: " + e.getMessage(), (Throwable)e);
                }
                return this.getEnumKeyValueConfiguration(this.getEnumConfigurationKeyResolver().resolveConfigurationKeyName(configurationKey));
            }
        }
        return enumKeyValueConfiguration;
    }
}

