/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.store.impl;

import com.github.toolarium.enumeration.configuration.converter.StringTypeConverterFactory;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.dto.SortedProperties;
import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationKeyResolver;
import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationStore;
import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationValue;
import com.github.toolarium.enumeration.configuration.store.dto.EnumConfigurationValue;
import com.github.toolarium.enumeration.configuration.store.exception.EnumConfigurationStoreException;
import com.github.toolarium.enumeration.configuration.store.impl.EnumConfigurationKeyResolver;
import com.github.toolarium.enumeration.configuration.util.EnumKeyValueConfigurationBinaryObjectParser;
import com.github.toolarium.enumeration.configuration.util.JSONUtil;
import com.github.toolarium.enumeration.configuration.validation.EnumKeyConfigurationValidatorFactory;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseEnumConfigurationStore
implements IEnumConfigurationStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBaseEnumConfigurationStore.class);
    private static final String INVALID_INPUT_CONFIGURATION_KEY_NAME = "Invalid input configuration key name!";
    private IEnumConfigurationKeyResolver enumConfigurationKeyResolver = new EnumConfigurationKeyResolver();

    @Override
    public <D> IEnumConfigurationValue<D> readConfigurationValue(String configurationKey) throws EnumConfigurationStoreException {
        return this.readConfigurationValue(configurationKey, true);
    }

    protected <D> IEnumConfigurationValue<D> readConfigurationValue(String inputConfigurationKeyName, boolean supportReturnDefaultValueIfMissing) throws EnumConfigurationStoreException {
        if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) {
            LOG.debug(INVALID_INPUT_CONFIGURATION_KEY_NAME);
            return null;
        }
        String configurationKeyName = inputConfigurationKeyName.trim();
        String value = this.prepareValue(this.getEnumKeyValueConfiguration(configurationKeyName), this.loadConfiguration(configurationKeyName), supportReturnDefaultValueIfMissing);
        IEnumConfigurationValue<D> result = null;
        if (value != null) {
            result = this.validate(configurationKeyName, value);
        }
        return result;
    }

    @Override
    public <D> IEnumConfigurationValue<D> readConfigurationValueIgnoreDefault(String configurationKey) throws EnumConfigurationStoreException {
        return this.readConfigurationValue(configurationKey, false);
    }

    @Override
    public <D> void writeConfigurationValue(String inputConfigurationKeyName, String value) throws EnumConfigurationStoreException {
        if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) {
            LOG.debug(INVALID_INPUT_CONFIGURATION_KEY_NAME);
            return;
        }
        String configurationKeyName = inputConfigurationKeyName.trim();
        this.validate(configurationKeyName, value);
        this.writeConfiguration(configurationKeyName, value);
    }

    @Override
    public <T extends Enum<T>> void writeConfigurationValue(String inputConfigurationKeyName, Object configurationValue) throws EnumConfigurationStoreException {
        if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) {
            LOG.debug(INVALID_INPUT_CONFIGURATION_KEY_NAME);
            return;
        }
        String configurationKeyName = inputConfigurationKeyName.trim();
        String value = this.convertObjectToString(configurationKeyName, this.getEnumKeyValueConfiguration(configurationKeyName), configurationValue);
        this.validate(configurationKeyName, value);
        this.writeConfiguration(configurationKeyName, value);
    }

    @Override
    public Properties readConfigurationValueList(String ... inputConfigurationKeyNames) throws EnumConfigurationStoreException {
        SortedProperties result = new SortedProperties();
        String[] configurationKeyNames = this.prepareConfigurationNames(inputConfigurationKeyNames);
        if (configurationKeyNames == null) {
            LOG.debug("Invalid input configuration key names!");
            return result;
        }
        if (configurationKeyNames != null && configurationKeyNames.length > 0) {
            for (String inputConfigurationKeyName : configurationKeyNames) {
                if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) continue;
                String configurationKeyName = inputConfigurationKeyName.trim();
                IEnumConfigurationValue value = this.readConfigurationValue(configurationKeyName);
                result.setProperty(configurationKeyName, this.handlingNullObject(value));
            }
        }
        return result;
    }

    @Override
    public Properties readConfigurationValueListIgnoreDefault(String ... inputConfigurationKeyNames) throws EnumConfigurationStoreException {
        SortedProperties result = new SortedProperties();
        String[] configurationKeyNames = this.prepareConfigurationNames(inputConfigurationKeyNames);
        if (configurationKeyNames == null) {
            LOG.debug("Invalid input configuration key names!");
            return result;
        }
        if (configurationKeyNames != null && configurationKeyNames.length > 0) {
            for (String inputConfigurationKeyName : configurationKeyNames) {
                if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) continue;
                String configurationKeyName = inputConfigurationKeyName.trim();
                IEnumConfigurationValue value = this.readConfigurationValueIgnoreDefault(configurationKeyName);
                result.setProperty(configurationKeyName, this.handlingNullObject(value));
            }
        }
        return result;
    }

    @Override
    public void writeConfigurationValueList(Properties configuration) throws EnumConfigurationStoreException {
        this.writeConfigurationValueList(configuration, false);
    }

    @Override
    public Properties writeConfigurationValueList(Properties configuration, boolean removeEntriesWithMissingKey) throws EnumConfigurationStoreException {
        if (configuration == null || configuration.isEmpty()) {
            LOG.debug("Invalid input configuration!");
            return new SortedProperties();
        }
        Set<String> keySetToDelete = null;
        if (removeEntriesWithMissingKey) {
            keySetToDelete = this.readKeys();
        }
        for (Map.Entry<Object, Object> e : configuration.entrySet()) {
            String valueStr;
            String configurationKeyName = ("" + e.getKey()).trim();
            if (configurationKeyName == null || configurationKeyName.isBlank() || (valueStr = "" + e.getValue()) == null || valueStr.isEmpty()) continue;
            if (removeEntriesWithMissingKey && keySetToDelete != null) {
                keySetToDelete.remove(configurationKeyName);
            }
            this.writeConfigurationValue(configurationKeyName, valueStr);
        }
        if (!removeEntriesWithMissingKey || keySetToDelete == null || keySetToDelete.isEmpty()) {
            return new SortedProperties();
        }
        String[] arrayOfString = (String[])Arrays.copyOf(keySetToDelete.toArray(), keySetToDelete.size(), String[].class);
        return this.deleteConfigurationValueList(arrayOfString);
    }

    @Override
    public <D> IEnumConfigurationValue<D> deleteConfigurationValue(String inputConfigurationKeyName) throws EnumConfigurationStoreException {
        if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) {
            LOG.debug(INVALID_INPUT_CONFIGURATION_KEY_NAME);
            return null;
        }
        IEnumConfigurationValue<D> result = this.readConfigurationValueIgnoreDefault(inputConfigurationKeyName);
        this.deleteConfiguration(inputConfigurationKeyName.trim());
        return result;
    }

    @Override
    public Properties deleteConfigurationValueList(String ... inputConfigurationKeyNames) throws EnumConfigurationStoreException {
        SortedProperties result = new SortedProperties();
        String[] configurationKeyNames = this.prepareConfigurationNames(inputConfigurationKeyNames);
        if (configurationKeyNames == null) {
            LOG.debug("Invalid input configuration key names!");
            return result;
        }
        if (configurationKeyNames != null && configurationKeyNames.length > 0) {
            for (String inputConfigurationKeyName : configurationKeyNames) {
                if (inputConfigurationKeyName == null || inputConfigurationKeyName.isBlank()) continue;
                String configurationKeyName = inputConfigurationKeyName.trim();
                result.setProperty(configurationKeyName, this.handlingNullObject(this.deleteConfiguration(configurationKeyName)));
            }
        }
        return result;
    }

    @Override
    public IEnumConfigurationKeyResolver getEnumConfigurationKeyResolver() {
        return this.enumConfigurationKeyResolver;
    }

    public void setEnumConfigurationKeyResolver(IEnumConfigurationKeyResolver enumConfigurationKeyResolver) {
        this.enumConfigurationKeyResolver = enumConfigurationKeyResolver;
    }

    protected String prepareValue(EnumKeyValueConfiguration enumKeyValueConfiguration, String inputValue, boolean supportReturnDefaultValueIfMissing) {
        String value = inputValue;
        if (value == null && supportReturnDefaultValueIfMissing && enumKeyValueConfiguration != null && enumKeyValueConfiguration.getDefaultValue() != null && !enumKeyValueConfiguration.getDefaultValue().isEmpty()) {
            value = enumKeyValueConfiguration.getDefaultValue();
        }
        try {
            value = EnumKeyValueConfigurationBinaryObjectParser.getInstance().mergeDefaultValues(enumKeyValueConfiguration, value);
        }
        catch (EnumConfigurationStoreException ex) {
            LOG.debug(ex.getMessage());
            throw ex;
        }
        return value;
    }

    protected <D> IEnumConfigurationValue<D> validate(String inputConfigurationKeyName, String value) throws EnumConfigurationStoreException {
        if (inputConfigurationKeyName == null) {
            LOG.debug(INVALID_INPUT_CONFIGURATION_KEY_NAME);
            throw new EnumConfigurationStoreException("Invalid configuration key name!");
        }
        String configurationKeyName = inputConfigurationKeyName;
        try {
            EnumKeyValueConfiguration enumKeyValueConfiguration = this.getEnumKeyValueConfiguration(configurationKeyName);
            Collection valueList = EnumKeyConfigurationValidatorFactory.getInstance().getValidator().validate(enumKeyValueConfiguration, value);
            return this.prepareResult(value, valueList);
        }
        catch (ValidationException ex) {
            String msg = "Invalid configuration found for key [" + configurationKeyName + "]: " + ex.getMessage();
            LOG.warn(msg);
            EnumConfigurationStoreException e = new EnumConfigurationStoreException(msg, ex);
            e.add(configurationKeyName, value, ex.getConvertedValueList());
            throw e;
        }
    }

    protected <D> IEnumConfigurationValue<D> prepareResult(String result, Collection<D> values) {
        return new EnumConfigurationValue<D>(result, values);
    }

    protected abstract String loadConfiguration(String var1) throws EnumConfigurationStoreException;

    protected abstract <D> void writeConfiguration(String var1, String var2) throws EnumConfigurationStoreException;

    protected abstract <D> String deleteConfiguration(String var1) throws EnumConfigurationStoreException;

    protected abstract Set<String> readKeys() throws EnumConfigurationStoreException;

    protected EnumKeyValueConfiguration getEnumKeyValueConfiguration(String inputConfigurationKeyName) throws EnumConfigurationStoreException {
        if (inputConfigurationKeyName == null) {
            LOG.debug(INVALID_INPUT_CONFIGURATION_KEY_NAME);
            return null;
        }
        return this.getEnumConfigurationKeyResolver().getEnumKeyValueConfiguration(inputConfigurationKeyName);
    }

    protected <T extends Enum<T>> String convertObjectToString(String configurationName, EnumKeyValueConfiguration enumKeyValueConfiguration, Object configurationValue) {
        String value;
        if (configurationValue == null) {
            value = null;
        } else if (configurationValue.getClass().isArray() || configurationValue.getClass().isAssignableFrom(Collection.class)) {
            ArrayList<String> list = new ArrayList<String>();
            EnumConfigurationStoreException ex = null;
            if (configurationValue.getClass().isArray()) {
                Object[] array = (Object[])configurationValue;
                for (int i = 0; i < array.length; ++i) {
                    try {
                        String str = StringTypeConverterFactory.getInstance().getStringTypeConverter().format(enumKeyValueConfiguration.getDataType(), array[i]);
                        if (str == null) continue;
                        list.add(str);
                        continue;
                    }
                    catch (ValidationException e) {
                        String msg = "Invalid configuration";
                        if (ex == null) {
                            ex = new EnumConfigurationStoreException(msg, e);
                        }
                        ex.add(configurationName, "" + array[i], e.getConvertedValueList());
                        LOG.warn(msg + " found for key [" + configurationName + "]: " + e.getMessage());
                    }
                }
            } else if (configurationValue.getClass().isAssignableFrom(Collection.class)) {
                for (Object object : (Collection)configurationValue) {
                    try {
                        list.add(StringTypeConverterFactory.getInstance().getStringTypeConverter().format(enumKeyValueConfiguration.getDataType(), object));
                    }
                    catch (ValidationException e) {
                        String msg = "Invalid configuration";
                        if (ex == null) {
                            ex = new EnumConfigurationStoreException(msg, e);
                        }
                        ex.add(configurationName, "" + object, e.getConvertedValueList());
                        LOG.warn(msg + " found for key [" + configurationName + "]: " + e.getMessage());
                    }
                }
            }
            if (ex != null) {
                throw ex;
            }
            value = JSONUtil.getInstance().convert(list);
        } else {
            value = configurationValue.toString();
        }
        return value;
    }

    protected String handlingNullObject(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    protected String[] prepareConfigurationNames(String ... inputConfigurationKeyNames) throws EnumConfigurationStoreException {
        String[] configurationKeyNames = inputConfigurationKeyNames;
        ArrayList<String> list = null;
        if (configurationKeyNames != null && configurationKeyNames.length > 0) {
            list = new ArrayList<String>();
            for (String configurationKeyName : configurationKeyNames) {
                if (configurationKeyName == null || configurationKeyName.isBlank()) continue;
                list.add(configurationKeyName);
            }
        }
        if (list == null || list.isEmpty()) {
            Set<String> keySet = this.readKeys();
            if (keySet != null) {
                return (String[])keySet.toArray(String[]::new);
            }
            return null;
        }
        return (String[])list.toArray(String[]::new);
    }
}

