/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.store.exception;

import com.github.toolarium.enumeration.configuration.store.IEnumConfigurationValue;
import com.github.toolarium.enumeration.configuration.store.dto.EnumConfigurationValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EnumConfigurationStoreException
extends RuntimeException {
    private static final long serialVersionUID = -247429687108299666L;
    private Map<String, IEnumConfigurationValue<Object>> invalidConfigurationValueMap;

    public EnumConfigurationStoreException() {
    }

    public EnumConfigurationStoreException(String msg) {
        super(msg);
    }

    public EnumConfigurationStoreException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public void add(String key, String value, Collection<Object> convertedObjectList) {
        if (key == null || value == null) {
            return;
        }
        if (this.invalidConfigurationValueMap == null) {
            this.invalidConfigurationValueMap = new HashMap<String, IEnumConfigurationValue<Object>>();
        }
        Collection<Object> collection = null;
        if (convertedObjectList != null) {
            collection = convertedObjectList;
        }
        this.invalidConfigurationValueMap.put(key, new EnumConfigurationValue<Object>(value, collection));
    }

    public Set<String> keySet() {
        if (this.invalidConfigurationValueMap == null) {
            return Collections.emptySet();
        }
        return this.invalidConfigurationValueMap.keySet();
    }

    public IEnumConfigurationValue<?> getInvalidConfigurationValue(String key) {
        if (key == null || this.invalidConfigurationValueMap == null) {
            return null;
        }
        return this.invalidConfigurationValueMap.get(key);
    }
}

