/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.resource;

import com.github.toolarium.enumeration.configuration.dto.EnumConfigurations;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.util.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class EnumConfigurationResourceFactory {
    private EnumConfigurationResourceFactory() {
    }

    public static EnumConfigurationResourceFactory getInstance() {
        return HOLDER.INSTANCE;
    }

    public <T extends EnumKeyConfiguration> EnumConfigurations load(InputStream inputstream) throws IOException {
        if (inputstream == null) {
            return null;
        }
        return JSONUtil.getInstance().read(EnumConfigurations.class, inputstream);
    }

    public void store(EnumConfigurations enumConfigurations, OutputStream outputStream) throws IOException {
        if (outputStream == null || enumConfigurations == null || enumConfigurations.getEnumConfigurationList() == null || enumConfigurations.getEnumConfigurationList().isEmpty()) {
            return;
        }
        JSONUtil.getInstance().write(enumConfigurations, outputStream);
    }

    private static class HOLDER {
        static final EnumConfigurationResourceFactory INSTANCE = new EnumConfigurationResourceFactory();

        private HOLDER() {
        }
    }
}

