/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.converter.impl;

import com.github.toolarium.enumeration.configuration.converter.impl.AbstractStringTypeConverter;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.util.ExceptionUtil;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;

public class DefaultStringTypConverter
extends AbstractStringTypeConverter {
    @Override
    public <T> T convert(EnumKeyValueConfigurationDataType dataType, String inputToTest) throws ValidationException {
        try {
            switch (dataType) {
                case NUMBER: {
                    return (T)this.getNumber(inputToTest);
                }
                case DOUBLE: {
                    return (T)this.getDouble(inputToTest);
                }
                case BOOLEAN: {
                    return (T)this.getBoolean(inputToTest);
                }
                case DATE: {
                    return (T)this.getDate(inputToTest);
                }
                case TIME: {
                    return (T)this.getTime(inputToTest);
                }
                case TIMESTAMP: {
                    return (T)this.getTimestamp(inputToTest);
                }
                case REGEXP: {
                    return (T)this.getRegExp(inputToTest);
                }
                case UUID: {
                    return (T)this.getUUID(inputToTest);
                }
                case URI: {
                    return (T)this.getURI(inputToTest);
                }
                case CIDR: {
                    return (T)this.getCIDR(inputToTest);
                }
                case EMAIL: {
                    return (T)this.getEmail(inputToTest);
                }
                case CRON: {
                    return (T)this.getCron(inputToTest);
                }
                case COLOR: {
                    return (T)this.getColor(inputToTest);
                }
                case CERTIFICATE: {
                    return (T)this.getCertificate(inputToTest);
                }
                case BINARY: {
                    return (T)this.getBinary(inputToTest);
                }
            }
            return (T)inputToTest;
        }
        catch (Exception e) {
            throw ExceptionUtil.getInstance().throwsException(ValidationException.class, this.prepareExceptionMessage(dataType, inputToTest, e), e.getStackTrace());
        }
    }

    @Override
    public String format(EnumKeyValueConfigurationDataType dataType, Object input) throws ValidationException {
        try {
            switch (dataType) {
                case NUMBER: {
                    return this.getNumberAsString(input);
                }
                case DOUBLE: {
                    return this.getDoubleAsString(input);
                }
            }
            return this.getObjectsString(input);
        }
        catch (Exception e) {
            throw ExceptionUtil.getInstance().throwsException(e, ValidationException.class, true);
        }
    }
}

