/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;
import java.util.UUID;

public class UUIDEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<UUID, Number> {
    private static final long serialVersionUID = 3680551029203917086L;

    public UUIDEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.UUID, UUID.class, EnumKeyValueConfigurationDataType.NUMBER);
    }

    @Override
    public UUID validateValue(EnumKeyValueConfigurationSizing<Number> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        UUID inputUUID = (UUID)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<Number> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputUUID;
        }
        if (inputUUID == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputUUID;
            }
            throw new EmptyValueException("Empty value: invalid string, should be at the length of [" + valueSize.getMinSizeAsString() + "]!");
        }
        return inputUUID;
    }

    @Override
    public EnumKeyValueConfigurationSizing<Number> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<Number>();
    }

    @Override
    public Long getMinSize() {
        return 0L;
    }

    @Override
    public Long getMaxSize() {
        return 36L;
    }

    @Override
    protected boolean isGreaterThan(Number first, Number second) {
        return this.isGreaterThanValue(first, second);
    }
}

