/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;

public class StringEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<String, Number> {
    private static final long serialVersionUID = -7649231162358270591L;

    public StringEnumKeyValueConfigurationValueValidator() {
        this(EnumKeyValueConfigurationDataType.STRING, EnumKeyValueConfigurationDataType.NUMBER);
    }

    protected StringEnumKeyValueConfigurationValueValidator(EnumKeyValueConfigurationDataType dataType, EnumKeyValueConfigurationDataType sizeDataType) {
        super(dataType, String.class, sizeDataType);
    }

    @Override
    public String validateValue(EnumKeyValueConfigurationSizing<Number> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        String inputString = (String)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<Number> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputString;
        }
        if (inputString == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputString;
            }
            throw new EmptyValueException("Empty value: invalid string, should be at the length of [" + valueSize.getMinSizeAsString() + "]!");
        }
        long inputLength = inputString.length();
        if (inputLength < minMaxValue.getMin().longValue()) {
            throw new ValidationException("Too short: invalid length of [" + inputValue + "], should be at least [" + minMaxValue.getMin() + "] (now " + inputLength + ")!");
        }
        if (inputLength > minMaxValue.getMax().longValue()) {
            throw new ValidationException("Too long: invalid length of [" + inputValue + "], should be in range of [" + minMaxValue.getMin() + ".." + minMaxValue.getMax() + "] (now " + inputLength + ")!");
        }
        return inputString;
    }

    @Override
    public EnumKeyValueConfigurationSizing<Number> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<Number>();
    }

    @Override
    public Long getMinSize() {
        return 0L;
    }

    @Override
    public Long getMaxSize() {
        return Long.MAX_VALUE;
    }

    @Override
    protected boolean isGreaterThan(Number first, Number second) {
        return this.isGreaterThanValue(first, second);
    }
}

