/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.util.DateUtil;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;
import java.time.LocalDate;

public class DateEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<LocalDate, LocalDate> {
    private static final long serialVersionUID = -5563031423758776454L;

    public DateEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.DATE, LocalDate.class, EnumKeyValueConfigurationDataType.DATE);
    }

    @Override
    public LocalDate validateValue(EnumKeyValueConfigurationSizing<LocalDate> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        LocalDate inputDate = (LocalDate)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<LocalDate> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputDate;
        }
        if (inputDate == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputDate;
            }
            throw new EmptyValueException("Empty value: invalid date, should be at least [" + valueSize.getMinSizeAsString() + "]!");
        }
        if (inputDate.compareTo(minMaxValue.getMin()) < 0) {
            throw new ValidationException("Too small: invalid date of [" + inputValue + "], should be at least [" + valueSize.getMinSizeAsString() + "] (now " + inputValue + ")!");
        }
        if (inputDate.compareTo(minMaxValue.getMax()) > 0) {
            throw new ValidationException("Too big: invalid date of [" + inputValue + "], should be in range of [" + valueSize.getMinSizeAsString() + ".." + valueSize.getMaxSizeAsString() + "] (now " + inputValue + ")!");
        }
        return inputDate;
    }

    @Override
    public EnumKeyValueConfigurationSizing<LocalDate> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<LocalDate>();
    }

    @Override
    public LocalDate getMinSize() {
        return LocalDate.EPOCH;
    }

    @Override
    public LocalDate getMaxSize() {
        return DateUtil.MAX_DATE;
    }

    @Override
    protected boolean isGreaterThan(LocalDate first, LocalDate second) {
        if (first == null) {
            return second != null;
        }
        if (second == null) {
            return false;
        }
        return first.isAfter(second);
    }
}

