/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.converter.StringTypeConverterFactory;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.IEnumKeyConfigurationValueValidator;
import java.io.Serializable;

public abstract class AbstractEnumKeyValueConfigurationValueValidator<D, T>
implements Serializable,
IEnumKeyConfigurationValueValidator<D, T> {
    private static final long serialVersionUID = 5414798875779082500L;
    private EnumKeyValueConfigurationDataType valueDataType;
    private EnumKeyValueConfigurationDataType sizeDataType;
    private Class<D> valueClass;

    protected AbstractEnumKeyValueConfigurationValueValidator(EnumKeyValueConfigurationDataType valueDataType, Class<D> valueClass, EnumKeyValueConfigurationDataType sizeDataType) {
        this.valueDataType = valueDataType;
        this.valueClass = valueClass;
        this.sizeDataType = sizeDataType;
    }

    @Override
    public EnumKeyValueConfigurationSizing<T> createValueSize(String minValue, String maxValue) throws ValidationException {
        if ((minValue == null || minValue.trim().isEmpty()) && (maxValue == null || maxValue.trim().isEmpty())) {
            return null;
        }
        EnumKeyValueConfigurationSizing<T> result = this.createEnumKeyValueConfigurationSizing();
        if (result != null) {
            if (minValue != null && !minValue.trim().isEmpty()) {
                result.setMinSizeAsString(minValue.trim());
                result.setMinSize(this.parseSizeValue(minValue.trim()));
            } else {
                result.setMinSize(this.getMinSize());
            }
            if (maxValue != null && !maxValue.trim().isEmpty()) {
                result.setMaxSizeAsString(maxValue.trim());
                result.setMaxSize(this.parseSizeValue(maxValue.trim()));
            } else {
                result.setMaxSize(this.getMaxSize());
            }
            if (!this.isGreaterThan(result.getMaxSize(), result.getMinSize()) && !result.getMaxSize().equals(result.getMinSize())) {
                throw new ValidationException("Invalid value size, max size [" + maxValue + "] should be gerater or equal than the min size [" + minValue + "]!");
            }
        }
        return result;
    }

    public T parseSizeValue(String input) throws ValidationException {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        if ("*".equals(input.trim())) {
            return this.getMaxSize();
        }
        return StringTypeConverterFactory.getInstance().getStringTypeConverter().convert(this.sizeDataType, input);
    }

    public D parseValue(String input) throws ValidationException {
        if (input == null || input.isEmpty()) {
            return null;
        }
        try {
            return (D)StringTypeConverterFactory.getInstance().getStringTypeConverter().convert(this.valueDataType, input);
        }
        catch (Exception e) {
            throw new ValidationException("Invalid value [" + input + "] (" + e.getMessage() + ")!");
        }
    }

    protected MinMaxValue<T> preapreMinMaxValue(EnumKeyValueConfigurationSizing<T> valueSize, String inputValue) throws ValidationException {
        if (valueSize == null) {
            return null;
        }
        T min = this.getMinSize();
        if (valueSize.getMinSize() != null) {
            min = valueSize.getMinSize();
        }
        T max = this.getMaxSize();
        if (valueSize.getMaxSize() != null) {
            max = valueSize.getMaxSize();
        }
        try {
            if (this.isGreaterThan(min, max)) {
                throw new ValidationException("Invalid maxValue / minValue of [" + inputValue + "], the minValue [" + valueSize.getMinSizeAsString() + "] should be <= then maxValue [" + valueSize.getMinSizeAsString() + "]!");
            }
        }
        catch (RuntimeException ex) {
            ValidationException e = new ValidationException(ex.getMessage());
            e.setStackTrace(ex.getStackTrace());
            throw ex;
        }
        return new MinMaxValue<T>(valueSize.getMinSizeAsString(), min, valueSize.getMaxSizeAsString(), max);
    }

    public abstract T getMinSize();

    public abstract T getMaxSize();

    protected abstract boolean isGreaterThan(T var1, T var2);

    protected boolean isGreaterThanValue(Number first, Number second) {
        Long s;
        if (first == null) {
            return second != null;
        }
        if (second == null) {
            return false;
        }
        Long f = first.longValue();
        return f.compareTo(s = Long.valueOf(second.longValue())) > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.valueDataType != null) {
            result += this.valueDataType.hashCode();
        }
        result = 31 * result;
        if (this.valueClass != null) {
            result += this.valueClass.hashCode();
        }
        result = 31 * result;
        if (this.sizeDataType != null) {
            result += this.sizeDataType.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEnumKeyValueConfigurationValueValidator other = (AbstractEnumKeyValueConfigurationValueValidator)obj;
        if (this.valueDataType != other.valueDataType) {
            return false;
        }
        if (this.valueClass == null ? other.valueClass != null : !this.valueClass.equals(other.valueClass)) {
            return false;
        }
        return this.sizeDataType == other.sizeDataType;
    }

    public String toString() {
        return this.getClass().getName() + " [valueDataType=" + this.valueDataType + ", valueClass=" + this.valueClass + ", sizeDataType=" + this.sizeDataType + "]";
    }

    class MinMaxValue<T>
    implements Serializable {
        private static final long serialVersionUID = -3107817743258894907L;
        private String minOriginal;
        private T min;
        private String maxOriginal;
        private T max;

        MinMaxValue(String minOriginal, T min, String maxOriginal, T max) {
            this.minOriginal = minOriginal;
            this.min = min;
            this.maxOriginal = maxOriginal;
            this.max = max;
        }

        public String getMinOriginal() {
            return this.minOriginal;
        }

        public T getMin() {
            return this.min;
        }

        public String getMaxOriginal() {
            return this.maxOriginal;
        }

        public T getMax() {
            return this.max;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31;
            if (this.minOriginal != null) {
                result += this.minOriginal.hashCode();
            }
            result = 31;
            if (this.min != null) {
                result += this.min.hashCode();
            }
            result = 31;
            if (this.maxOriginal != null) {
                result += this.maxOriginal.hashCode();
            }
            result = 31;
            if (this.max != null) {
                result += this.max.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MinMaxValue other = (MinMaxValue)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.minOriginal == null ? other.minOriginal != null : !this.minOriginal.equals(other.minOriginal)) {
                return false;
            }
            if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
                return false;
            }
            if (this.maxOriginal == null ? other.maxOriginal != null : !this.maxOriginal.equals(other.maxOriginal)) {
                return false;
            }
            return !(this.max == null ? other.max != null : !this.max.equals(other.max));
        }

        private AbstractEnumKeyValueConfigurationValueValidator getEnclosingInstance() {
            return AbstractEnumKeyValueConfigurationValueValidator.this;
        }
    }
}

