/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.util.ExceptionUtil;
import com.github.toolarium.enumeration.configuration.util.JSONUtil;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.IEnumKeyConfigurationValidator;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.EnumKeyValueConfigurationValueValidatorFactory;
import com.github.toolarium.enumeration.configuration.validation.value.IEnumKeyConfigurationValueValidator;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractEnumKeyConfigurationValidator
implements IEnumKeyConfigurationValidator {
    protected AbstractEnumKeyConfigurationValidator() {
    }

    @Override
    public void validate(EnumKeyConfiguration enumKeyConfiguration, String input) throws ValidationException {
        this.validate(enumKeyConfiguration);
    }

    @Override
    public <D> Collection<D> validate(EnumKeyValueConfiguration enumKeyValueConfiguration, String input) throws ValidationException {
        this.validate(enumKeyValueConfiguration);
        return this.validate(enumKeyValueConfiguration.getDataType(), enumKeyValueConfiguration.getCardinality(), enumKeyValueConfiguration.uniqueness(), enumKeyValueConfiguration.getValueSize(), enumKeyValueConfiguration.getEnumerationValue(), input);
    }

    @Override
    public void validate(EnumKeyConfiguration enumKeyConfiguration) throws ValidationException {
        if (enumKeyConfiguration == null) {
            throw new ValidationException("Invalid enumKeyConfiguration!");
        }
        this.validateKey(enumKeyConfiguration.getKey());
        this.validateDescription(enumKeyConfiguration.getDescription());
        this.validateValidity(enumKeyConfiguration.getValidFrom(), enumKeyConfiguration.getValidTill());
    }

    @Override
    public void validate(EnumKeyValueConfiguration enumKeyValueConfiguration) throws ValidationException {
        if (enumKeyValueConfiguration == null) {
            throw new ValidationException("Invalid enumKeyConfiguration!");
        }
        this.validateKey(enumKeyValueConfiguration.getKey());
        this.validateDescription(enumKeyValueConfiguration.getDescription());
        this.validateValidity(enumKeyValueConfiguration.getValidFrom(), enumKeyValueConfiguration.getValidTill());
        this.validateDefaultValue(enumKeyValueConfiguration.getDataType(), enumKeyValueConfiguration.getCardinality(), enumKeyValueConfiguration.uniqueness(), enumKeyValueConfiguration.getValueSize(), enumKeyValueConfiguration.getEnumerationValue(), enumKeyValueConfiguration.getDefaultValue());
        this.validateExampleValue(enumKeyValueConfiguration.getDataType(), enumKeyValueConfiguration.getCardinality(), enumKeyValueConfiguration.uniqueness(), enumKeyValueConfiguration.getValueSize(), enumKeyValueConfiguration.getEnumerationValue(), enumKeyValueConfiguration.getExampleValue());
        this.validateEnumerationValue(enumKeyValueConfiguration.getDataType(), enumKeyValueConfiguration.getCardinality(), enumKeyValueConfiguration.uniqueness(), enumKeyValueConfiguration.getValueSize(), enumKeyValueConfiguration.getEnumerationValue());
    }

    @Override
    public <D, T> Collection<D> validate(EnumKeyValueConfigurationDataType dataType, EnumKeyValueConfigurationSizing<Integer> cardinality, boolean uniqueness, EnumKeyValueConfigurationSizing<T> valueSize, String enumerationValue, String input) throws ValidationException {
        try {
            return this.validateValue("input", dataType, cardinality, uniqueness, valueSize, enumerationValue, input);
        }
        catch (ValidationException ex) {
            throw ExceptionUtil.getInstance().throwsException(ValidationException.class, "[input] " + ex.getMessage(), ex.getStackTrace());
        }
    }

    protected void validateDescription(String description) throws ValidationException {
        char lastCharacter;
        if (description == null || description.trim().isEmpty()) {
            throw new ValidationException("Invalid description!");
        }
        String[] descriptionSplit = description.split(" ");
        if (descriptionSplit == null || descriptionSplit.length <= 1) {
            throw new ValidationException("Invalid description, the description is too short!");
        }
        if (descriptionSplit[0].toUpperCase().charAt(0) != descriptionSplit[0].charAt(0)) {
            throw new ValidationException("Invalid description, it must begin with a capital letter!");
        }
        if (descriptionSplit.length > 2 && (lastCharacter = description.charAt(description.length() - 1)) != '.' && lastCharacter != '!' && lastCharacter != '?') {
            throw new ValidationException("Invalid description, it don't ends with a punctuation mark!");
        }
    }

    protected void validateKey(String key) throws ValidationException {
        if (key == null || key.trim().isEmpty()) {
            throw new ValidationException("Invalid key!");
        }
    }

    protected void validateValidity(Instant validFrom, Instant validTill) throws ValidationException {
        if (validFrom == null) {
            throw new ValidationException("Invalid validFrom date!");
        }
        if (validTill == null) {
            throw new ValidationException("Invalid validTill date!");
        }
        if (!validFrom.isBefore(validTill)) {
            throw new ValidationException("Invalid validFrom / validTill date!");
        }
    }

    protected <D, T> Collection<D> validateDefaultValue(EnumKeyValueConfigurationDataType dataType, EnumKeyValueConfigurationSizing<Integer> cardinality, boolean uniqueness, EnumKeyValueConfigurationSizing<T> valueSize, String enumerationValue, String inputDefaultValue) throws ValidationException {
        String defaultValue = inputDefaultValue;
        if (defaultValue == null || defaultValue.isBlank()) {
            return null;
        }
        try {
            return this.validateValue("defaultValue", dataType, cardinality, uniqueness, valueSize, enumerationValue, defaultValue);
        }
        catch (ValidationException ex) {
            throw ExceptionUtil.getInstance().throwsException(ValidationException.class, "[defaultValue] " + ex.getMessage(), ex.getStackTrace());
        }
    }

    protected <D, T> Collection<D> validateExampleValue(EnumKeyValueConfigurationDataType dataType, EnumKeyValueConfigurationSizing<Integer> cardinality, boolean uniqueness, EnumKeyValueConfigurationSizing<?> valueSize, String enumerationValue, String inputExampleValue) throws ValidationException {
        EnumKeyValueConfigurationSizing<Integer> exampleValueCardinality;
        String exampleValue = inputExampleValue;
        if (exampleValue == null || exampleValue.isBlank()) {
            exampleValue = null;
        }
        if ((exampleValueCardinality = cardinality).getMinSize() == null || exampleValueCardinality.getMinSize() < 0) {
            exampleValueCardinality = new EnumKeyValueConfigurationSizing<Integer>(1, cardinality.getMaxSize());
            exampleValueCardinality.setMaxSizeAsString(cardinality.getMaxSizeAsString());
        }
        try {
            return this.validateValue("exampleValue", dataType, exampleValueCardinality, uniqueness, valueSize, enumerationValue, exampleValue);
        }
        catch (ValidationException ex) {
            String msg = ex.getMessage();
            msg = msg.replace("minSize=1", "minSize=" + cardinality.getMinSizeAsString());
            throw ExceptionUtil.getInstance().throwsException(ValidationException.class, "[exampleValue] " + msg, ex.getStackTrace());
        }
    }

    protected <D, T> Collection<D> validateEnumerationValue(EnumKeyValueConfigurationDataType dataType, EnumKeyValueConfigurationSizing<Integer> cardinality, boolean uniqueness, EnumKeyValueConfigurationSizing<T> valueSize, String inputEnumerationValue) throws ValidationException {
        String enumerationValue = inputEnumerationValue;
        if (enumerationValue == null || enumerationValue.isBlank()) {
            return null;
        }
        try {
            return this.validateValue("enumerationValue", dataType, cardinality, uniqueness, valueSize, null, enumerationValue);
        }
        catch (ValidationException ex) {
            throw ExceptionUtil.getInstance().throwsException(ValidationException.class, "[enumerationValue] " + ex.getMessage(), ex.getStackTrace());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <D, T> Collection<D> validateValue(String inputType, EnumKeyValueConfigurationDataType dataType, EnumKeyValueConfigurationSizing<Integer> cardinality, boolean uniqueness, EnumKeyValueConfigurationSizing<T> valueSize, String enumerationValue, String input) throws EmptyValueException, ValidationException {
        boolean isMandatory;
        if (dataType == null) {
            throw new ValidationException("Invalid dataType in [" + inputType + "]! ");
        }
        boolean bl = isMandatory = cardinality != null && cardinality.getMinSize() != null && cardinality.getMinSize() > 0;
        if ((input == null || input.isEmpty()) && isMandatory) {
            throw new ValidationException("Missing [" + inputType + "], its mandatory and not optional (cardinality: " + cardinality + ")!");
        }
        Collection<D> enumarationValues = this.validateEnumerationValue(dataType, cardinality, uniqueness, valueSize, enumerationValue);
        AbstractCollection collection = null;
        collection = uniqueness ? new HashSet() : new ArrayList();
        if (cardinality == null || cardinality.getMaxSize() == null || cardinality.getMaxSize() <= 1) {
            if (cardinality != null && cardinality.getMinSize() != null && cardinality.getMaxSize() < cardinality.getMinSize()) {
                throw new ValidationException("Invalid cardinality of [" + inputType + "], the minSize [" + cardinality.getMinSize() + "] should be <= then maxSize [" + cardinality.getMaxSize() + "]! ");
            }
            try {
                D value = this.validateValue(inputType, dataType, valueSize, input);
                collection.add(value);
                return collection;
            }
            catch (EmptyValueException ex) {
                if (cardinality != null && cardinality.getMinSize() != null && cardinality.getMinSize() <= 0) return collection;
                throw ex;
            }
        }
        try {
            int length = 0;
            List<String> inputList = JSONUtil.getInstance().convert(input);
            if (inputList != null) {
                length = inputList.size();
            }
            if (cardinality.getMinSize() != null && length < cardinality.getMinSize()) {
                throw new ValidationException("Invalid cardinality of [" + inputType + "], the minSize is [" + cardinality.getMinSize() + "]! ");
            }
            if (cardinality.getMaxSize() != null && length > cardinality.getMaxSize()) {
                throw new ValidationException("Invalid cardinality of [" + inputType + "], the maxSize is [" + cardinality.getMaxSize() + "]! ");
            }
            if (inputList == null) return collection;
            for (String in : inputList) {
                try {
                    D value = this.validateValue(inputType, dataType, valueSize, in);
                    if (enumarationValues != null && !enumarationValues.contains(value)) {
                        throw new ValidationException("Invalid enumeration of [" + inputType + "] for intput [" + input + "], allowed values are: " + enumerationValue);
                    }
                    if (collection.add(value)) continue;
                    throw new ValidationException("Invalid uniqueness of [" + inputType + "] for intput [" + input + "]. Value already exist!");
                }
                catch (EmptyValueException ex) {
                    if (cardinality != null && cardinality.getMinSize() != null && cardinality.getMinSize() <= 0) continue;
                    throw ex;
                    return collection;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Invalid cardinality of [" + inputType + "] for intput [" + input + "]. Expected a JSON array: " + e.getMessage());
        }
    }

    protected <D, T> D validateValue(String inputType, EnumKeyValueConfigurationDataType dataType, EnumKeyValueConfigurationSizing<T> valueSize, String input) throws EmptyValueException, ValidationException {
        if (dataType == null) {
            throw new ValidationException("Invalid dataType in [" + inputType + "]! ");
        }
        IEnumKeyConfigurationValueValidator<?, ?> validator = EnumKeyValueConfigurationValueValidatorFactory.getInstance().createEnumKeyValueConfigurationValueValidator(dataType);
        return (D)validator.validateValue(valueSize, input);
    }
}

