/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;

public final class DateUtil {
    public static final LocalDate MAX_DATE = DateUtil.getInstance().parseDate("9999-12-31");
    public static final LocalTime MAX_TIME = DateUtil.getInstance().parseTime("23:59:59.999");
    public static final Instant MAX_TIMESTAMP = DateUtil.getInstance().parseTimestamp("9999-12-31T12:00:00.000Z");

    private DateUtil() {
    }

    public static DateUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public LocalDate parseDate(String input) {
        if (input == null) {
            return null;
        }
        return LocalDate.parse(input.trim());
    }

    public LocalTime parseTime(String input) {
        if (input == null) {
            return null;
        }
        return LocalTime.parse(input.trim());
    }

    public Instant parseTimestamp(String input) {
        if (input == null) {
            return null;
        }
        return Instant.parse(input.trim());
    }

    private static class HOLDER {
        static final DateUtil INSTANCE = new DateUtil();

        private HOLDER() {
        }
    }
}

