/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class CIDRUtil {
    public static final String IPV4_EXPRESSION = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    public static final String IPV6_EXPRESSION_STD = "(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}";
    public static final String IPV6_EXPRESSION_HEX_COMPRESSED = "((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)";
    public static final String IPV6_EXPRESSION = "^(((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)))$";
    public static final String IPV4_RANGE_EXPRESSION = "^([0-9]{1,3}\\.){3}[0-9]{1,3}/([0-9]|[1-2][0-9]|3[0-2])$";
    public static final String IPV6_RANGE_EXPRESSION = "^s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:)))(%.+)?s*/([0-9]|[1-9][0-9]|1[0-1][0-9]|12[0-8])$";
    private Pattern ipv4Expression = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
    private Pattern ipv6Expression = Pattern.compile("^(((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)))$");
    private Pattern ipv4RangeExpression = Pattern.compile("^([0-9]{1,3}\\.){3}[0-9]{1,3}/([0-9]|[1-2][0-9]|3[0-2])$");
    private Pattern ipv6RangeExpression = Pattern.compile("^s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:)))(%.+)?s*/([0-9]|[1-9][0-9]|1[0-1][0-9]|12[0-8])$");

    private CIDRUtil() {
    }

    public static CIDRUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public boolean isValidAddress(String host) {
        String address;
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        if (this.isIPv4Address(host) || this.isIPv6Address(host)) {
            return true;
        }
        InetAddress ipAddress = this.parseAddress(host);
        return ipAddress != null && (address = ipAddress.getHostAddress()) != null && (this.isIPv4Address(address) || this.isIPv6Address(address));
    }

    public boolean isValidAddressRange(String host) {
        String address;
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        if (this.isIPv4Range(host) || this.isIPv6Range(host)) {
            return true;
        }
        InetAddress ipAddress = this.parseAddress(host);
        return ipAddress != null && (address = ipAddress.getHostAddress()) != null && (this.isIPv4Range(address) || this.isIPv6Range(address));
    }

    public boolean isIPv4Address(String host) {
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        return this.ipv4Expression.matcher(host).matches();
    }

    public boolean isIPv6Address(String host) {
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        return this.ipv6Expression.matcher(host).matches();
    }

    public boolean isValidRange(String host) {
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        return this.isIPv4Range(host) || this.isIPv6Range(host);
    }

    public boolean isIPv4Range(String host) {
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        return this.ipv4RangeExpression.matcher(host).matches();
    }

    public boolean isIPv6Range(String host) {
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        return this.ipv6RangeExpression.matcher(host).matches();
    }

    public boolean isInRange(String hostRange, String host) {
        if (!this.isValidAddress(host)) {
            return false;
        }
        InetAddress inetAdress = this.parseAddress(host);
        if (inetAdress == null) {
            return false;
        }
        String remoteAddress = inetAdress.getHostAddress();
        if (remoteAddress == null || !this.isValidAddress(remoteAddress)) {
            return false;
        }
        if (!remoteAddress.equals(host)) {
            // empty if block
        }
        String hostRangeAddress = hostRange.trim();
        if (hostRange.equals(host) || hostRange.equals(remoteAddress)) {
            if (hostRange.equals(host) || hostRange.equals(remoteAddress)) {
                // empty if block
            }
            return true;
        }
        if (!this.isValidRange(hostRangeAddress)) {
            inetAdress = this.parseAddress(hostRangeAddress);
            if (inetAdress == null) {
                return false;
            }
            hostRangeAddress = inetAdress.getHostAddress();
            if (hostRangeAddress == null || !this.isValidAddress(hostRangeAddress)) {
                return false;
            }
            return hostRangeAddress.equals(remoteAddress);
        }
        boolean result = false;
        try {
            CIDR cidr = this.parse(hostRangeAddress);
            result = cidr.isInRange(remoteAddress) || cidr.getBroadcastAddress().equals(remoteAddress) || cidr.getNetworkAddress().equals(remoteAddress);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public CIDR parse(String cidrExpression) throws UnknownHostException {
        if (cidrExpression == null || cidrExpression.trim().isEmpty() || !cidrExpression.contains("/")) {
            throw new UnknownHostException("Invalid CIDR format: [" + cidrExpression + "]!");
        }
        String cidr = cidrExpression.trim();
        int index = cidr.indexOf("/");
        String addressPart = cidr.substring(0, index);
        String networkPart = cidr.substring(index + 1);
        return this.prepareCIDR(InetAddress.getByName(addressPart), Integer.parseInt(networkPart));
    }

    private CIDR prepareCIDR(InetAddress inetAddress, int prefixLength) throws UnknownHostException {
        int targetSize;
        ByteBuffer maskBuffer;
        if (inetAddress.getAddress().length == 4) {
            maskBuffer = ByteBuffer.allocate(4).putInt(-1);
            targetSize = 4;
        } else {
            maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
            targetSize = 16;
        }
        BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(prefixLength);
        ByteBuffer buffer = ByteBuffer.wrap(inetAddress.getAddress());
        BigInteger ipVal = new BigInteger(1, buffer.array());
        BigInteger startIp = ipVal.and(mask);
        BigInteger endIp = startIp.add(mask.not());
        byte[] startIpArr = this.toBytes(startIp.toByteArray(), targetSize);
        byte[] endIpArr = this.toBytes(endIp.toByteArray(), targetSize);
        return new CIDR(InetAddress.getByAddress(startIpArr), InetAddress.getByAddress(endIpArr));
    }

    private byte[] toBytes(byte[] input, int targetSize) {
        ArrayList<Byte> newArr = new ArrayList<Byte>();
        for (int counter = 0; counter < targetSize && input.length - 1 - counter >= 0; ++counter) {
            newArr.add(0, input[input.length - 1 - counter]);
        }
        int size = newArr.size();
        for (int i = 0; i < targetSize - size; ++i) {
            newArr.add(0, (byte)0);
        }
        byte[] ret = new byte[newArr.size()];
        for (int i = 0; i < newArr.size(); ++i) {
            ret[i] = (Byte)newArr.get(i);
        }
        return ret;
    }

    private InetAddress parseAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    class CIDR {
        private InetAddress startAddress;
        private InetAddress endAddress;

        CIDR(InetAddress startAddress, InetAddress endAddress) {
            this.startAddress = startAddress;
            this.endAddress = endAddress;
        }

        public String getNetworkAddress() {
            return this.startAddress.getHostAddress();
        }

        public String getBroadcastAddress() {
            return this.endAddress.getHostAddress();
        }

        public boolean isInRange(String ipAddress) throws UnknownHostException {
            InetAddress address = InetAddress.getByName(ipAddress);
            BigInteger start = new BigInteger(1, this.startAddress.getAddress());
            BigInteger end = new BigInteger(1, this.endAddress.getAddress());
            BigInteger target = new BigInteger(1, address.getAddress());
            int st = start.compareTo(target);
            int te = target.compareTo(end);
            return !(st != -1 && st != 0 || te != -1 && te != 0);
        }
    }

    private static class HOLDER {
        static final CIDRUtil INSTANCE = new CIDRUtil();

        private HOLDER() {
        }
    }
}

