/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.util;

import com.github.toolarium.enumeration.configuration.annotation.EnumConfiguration;
import com.github.toolarium.enumeration.configuration.converter.StringTypeConverterFactory;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.util.DateUtil;
import com.github.toolarium.enumeration.configuration.util.EnumUtil;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.EnumKeyValueConfigurationValueValidatorFactory;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public final class AnnotationConvertUtil {
    private AnnotationConvertUtil() {
    }

    public static AnnotationConvertUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public <T extends EnumKeyConfiguration> com.github.toolarium.enumeration.configuration.dto.EnumConfiguration<T> convert(EnumConfiguration enumConfigurationAnnotation) {
        if (enumConfigurationAnnotation == null) {
            return null;
        }
        com.github.toolarium.enumeration.configuration.dto.EnumConfiguration enumConfiguration = new com.github.toolarium.enumeration.configuration.dto.EnumConfiguration();
        enumConfiguration.setDescription(enumConfigurationAnnotation.description());
        if (enumConfigurationAnnotation.validFrom() != null && !enumConfigurationAnnotation.validFrom().trim().isEmpty()) {
            enumConfiguration.setValidFrom(DateUtil.getInstance().parseTimestamp(enumConfigurationAnnotation.validFrom()));
        }
        if (enumConfigurationAnnotation.validTill() != null && !enumConfigurationAnnotation.validTill().trim().isEmpty()) {
            enumConfiguration.setValidTill(DateUtil.getInstance().parseTimestamp(enumConfigurationAnnotation.validTill()));
        }
        return enumConfiguration;
    }

    public EnumKeyConfiguration convert(com.github.toolarium.enumeration.configuration.annotation.EnumKeyConfiguration enumKeyConfigurationAnnotation) throws ValidationException {
        if (enumKeyConfigurationAnnotation == null) {
            return null;
        }
        EnumKeyValueConfiguration enumKeyConfiguration = null;
        enumKeyConfiguration = new EnumKeyValueConfiguration();
        enumKeyConfiguration.setDescription(enumKeyConfigurationAnnotation.description());
        enumKeyConfiguration.setConfidential(enumKeyConfigurationAnnotation.isConfidential());
        if (enumKeyConfigurationAnnotation.validFrom() != null && !enumKeyConfigurationAnnotation.validFrom().trim().isEmpty()) {
            enumKeyConfiguration.setValidFrom(DateUtil.getInstance().parseTimestamp(enumKeyConfigurationAnnotation.validFrom()));
        }
        if (enumKeyConfigurationAnnotation.validTill() != null && !enumKeyConfigurationAnnotation.validTill().trim().isEmpty()) {
            enumKeyConfiguration.setValidTill(DateUtil.getInstance().parseTimestamp(enumKeyConfigurationAnnotation.validTill()));
        }
        return enumKeyConfiguration;
    }

    public EnumKeyValueConfiguration convert(com.github.toolarium.enumeration.configuration.annotation.EnumKeyValueConfiguration enumKeyValueConfigurationAnnotation) throws ValidationException {
        if (enumKeyValueConfigurationAnnotation == null) {
            return null;
        }
        EnumKeyValueConfiguration enumKeyValueConfiguration = null;
        enumKeyValueConfiguration = new EnumKeyValueConfiguration();
        enumKeyValueConfiguration.setDescription(enumKeyValueConfigurationAnnotation.description());
        EnumKeyValueConfigurationDataType type = EnumUtil.getInstance().mapEnum(EnumKeyValueConfigurationDataType.class, enumKeyValueConfigurationAnnotation.dataType());
        enumKeyValueConfiguration.setDataType(type);
        enumKeyValueConfiguration.setDefaultValue(enumKeyValueConfigurationAnnotation.defaultValue());
        enumKeyValueConfiguration.setValueSize(EnumKeyValueConfigurationValueValidatorFactory.getInstance().createEnumKeyValueConfigurationSizing(enumKeyValueConfiguration.getDataType(), enumKeyValueConfigurationAnnotation.minValue(), enumKeyValueConfigurationAnnotation.maxValue()));
        enumKeyValueConfiguration.setExampleValue(enumKeyValueConfigurationAnnotation.exampleValue());
        enumKeyValueConfiguration.setEnumerationValue(enumKeyValueConfigurationAnnotation.enumerationValue());
        enumKeyValueConfiguration.setCardinality(this.parseCardinality(enumKeyValueConfigurationAnnotation.cardinality()));
        enumKeyValueConfiguration.setUniqueness(enumKeyValueConfigurationAnnotation.uniqueness());
        enumKeyValueConfiguration.setConfidential(enumKeyValueConfigurationAnnotation.isConfidential());
        if (enumKeyValueConfigurationAnnotation.validFrom() != null && !enumKeyValueConfigurationAnnotation.validFrom().trim().isEmpty()) {
            enumKeyValueConfiguration.setValidFrom(DateUtil.getInstance().parseTimestamp(enumKeyValueConfigurationAnnotation.validFrom()));
        }
        if (enumKeyValueConfigurationAnnotation.validTill() != null && !enumKeyValueConfigurationAnnotation.validTill().trim().isEmpty()) {
            enumKeyValueConfiguration.setValidTill(DateUtil.getInstance().parseTimestamp(enumKeyValueConfigurationAnnotation.validTill()));
        }
        return enumKeyValueConfiguration;
    }

    public EnumKeyValueConfigurationSizing<Integer> parseCardinality(String inputCardinality) {
        if (inputCardinality == null || inputCardinality.trim().isEmpty()) {
            return null;
        }
        EnumKeyValueConfigurationSizing<Integer> cardinality = new EnumKeyValueConfigurationSizing<Integer>(1, 1);
        String cardinalityString = inputCardinality.trim();
        int idx = cardinalityString.indexOf("..");
        if (idx >= 0) {
            String value;
            try {
                value = cardinalityString.substring(0, idx).trim();
                cardinality.setMinSizeAsString(value);
                cardinality.setMinSize(Integer.valueOf(value));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid min cardinality value [" + cardinalityString.substring(0, idx) + "], expected [min]..[max]!");
            }
            if (cardinalityString.length() > idx + 2) {
                value = cardinalityString.substring(idx + 2).trim();
                try {
                    cardinality.setMaxSizeAsString(value);
                    if ("*".equals(value)) {
                        cardinality.setMaxSize(Integer.MAX_VALUE);
                    }
                    cardinality.setMaxSize(Integer.valueOf(value));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid max cardinality value [" + value + "], expected [min]..[max]!");
                }
            }
        } else {
            try {
                String value = cardinalityString.trim();
                cardinality.setMaxSizeAsString(value);
                if ("*".equals(value)) {
                    cardinality.setMaxSize(Integer.MAX_VALUE);
                } else {
                    cardinality.setMaxSize(Integer.valueOf(value));
                }
                if (cardinality.getMaxSize() < cardinality.getMinSize()) {
                    cardinality.setMinSize(cardinality.getMaxSize());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid cardinality value [" + cardinalityString + "], expected [min]..[max]!");
            }
        }
        return cardinality;
    }

    public <T> T parseSizeValue(EnumKeyValueConfigurationDataType dataType, String input) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        String value = input.trim();
        try {
            return StringTypeConverterFactory.getInstance().getStringTypeConverter().convert(dataType, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid size value [" + value + "]!");
        }
    }

    public <T extends ExecutableElement> String getName(T type) {
        if (type == null) {
            return "";
        }
        return this.trimQuotationMarks(type.getSimpleName().toString());
    }

    public <T extends AnnotationValue> String getValue(T type) {
        if (type == null) {
            return "";
        }
        return "" + type.getValue();
    }

    public String trimQuotationMarks(String input) {
        String result = input;
        if (result == null) {
            return result;
        }
        if (result.length() > 1 && result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.length() > 1 && result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static class HOLDER {
        static final AnnotationConvertUtil INSTANCE = new AnnotationConvertUtil();

        private HOLDER() {
        }
    }
}

