/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.processor;

import com.github.toolarium.enumeration.configuration.annotation.EnumConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumConfigurations;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.resource.EnumConfigurationResourceFactory;
import com.github.toolarium.enumeration.configuration.util.AnnotationConvertUtil;
import com.github.toolarium.enumeration.configuration.util.DateUtil;
import com.github.toolarium.enumeration.configuration.util.EnumUtil;
import com.github.toolarium.enumeration.configuration.validation.EnumKeyConfigurationValidatorFactory;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.EnumKeyValueConfigurationValueValidatorFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"enumconfiguration.validate.strict"})
public class EnumConfigurationProcessor
extends AbstractProcessor {
    private static final String ENUM_CONFIGURATION = "com.github.toolarium.enumeration.configuration.IEnumConfiguration";
    private List<Class<? extends Annotation>> annoationClassList = Arrays.asList(EnumConfiguration.class, com.github.toolarium.enumeration.configuration.annotation.EnumKeyConfiguration.class, com.github.toolarium.enumeration.configuration.annotation.EnumKeyValueConfiguration.class);
    private List<String> warnList = new ArrayList<String>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> result = new HashSet<String>();
        for (Class<? extends Annotation> c : this.annoationClassList) {
            result.add(c.getName());
        }
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        com.github.toolarium.enumeration.configuration.dto.EnumConfiguration enumConfiguration;
        if (roundEnv.processingOver()) {
            return false;
        }
        if (annotations.size() == 0) {
            return true;
        }
        LinkedHashMap enumConfigurationContentMap = new LinkedHashMap();
        for (Element element : roundEnv.getElementsAnnotatedWith(EnumConfiguration.class)) {
            com.github.toolarium.enumeration.configuration.dto.EnumConfiguration enumConfiguration2 = this.processEnumConfigurationElement((TypeElement)element);
            String string = enumConfiguration2.getName().trim();
            if (enumConfigurationContentMap.containsKey(string)) continue;
            enumConfigurationContentMap.put(string, enumConfiguration2);
        }
        Set<? extends Element> enumKeyValueConfigurationSet = roundEnv.getElementsAnnotatedWith(com.github.toolarium.enumeration.configuration.annotation.EnumKeyConfiguration.class);
        if (enumKeyValueConfigurationSet != null && !enumKeyValueConfigurationSet.isEmpty()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(com.github.toolarium.enumeration.configuration.annotation.EnumKeyConfiguration.class)) {
                String string = "" + element.getEnclosingElement();
                enumConfiguration = (com.github.toolarium.enumeration.configuration.dto.EnumConfiguration)enumConfigurationContentMap.get(string);
                if (enumConfiguration == null) {
                    if (this.warnList.contains(string)) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Missing EnumConfiguration reference on enum in " + string);
                    this.warnList.add(string);
                    continue;
                }
                EnumKeyConfiguration enumKeyConfiguration = this.processEnumKeyConfigurationElement(element);
                if (enumKeyConfiguration == null) continue;
                enumConfiguration.add(enumKeyConfiguration);
            }
        }
        if ((enumKeyValueConfigurationSet = roundEnv.getElementsAnnotatedWith(com.github.toolarium.enumeration.configuration.annotation.EnumKeyValueConfiguration.class)) != null && !enumKeyValueConfigurationSet.isEmpty()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(com.github.toolarium.enumeration.configuration.annotation.EnumKeyValueConfiguration.class)) {
                String string = "" + element.getEnclosingElement();
                enumConfiguration = (com.github.toolarium.enumeration.configuration.dto.EnumConfiguration)enumConfigurationContentMap.get(string);
                if (enumConfiguration == null) {
                    if (this.warnList.contains(string)) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Missing EnumConfiguration reference on enum in " + string);
                    this.warnList.add(string);
                    continue;
                }
                EnumKeyValueConfiguration enumKeyValueConfiguration = this.processEnumKeyValueConfigurationElement(element);
                if (enumKeyValueConfiguration == null) continue;
                enumConfiguration.add(enumKeyValueConfiguration);
            }
        }
        EnumConfigurations enumConfigurations = new EnumConfigurations();
        for (Map.Entry entry : enumConfigurationContentMap.entrySet()) {
            enumConfigurations.add((com.github.toolarium.enumeration.configuration.dto.EnumConfiguration)entry.getValue());
        }
        if (enumConfigurations.getEnumConfigurationList() != null && !enumConfigurations.getEnumConfigurationList().isEmpty()) {
            try {
                FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/toolarium-enum-configuration.json", new Element[0]);
                EnumConfigurationResourceFactory.getInstance().store(enumConfigurations, fileObject.openOutputStream());
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.getMessage());
            }
        }
        return false;
    }

    private <T extends EnumKeyConfiguration> com.github.toolarium.enumeration.configuration.dto.EnumConfiguration<T> processEnumConfigurationElement(TypeElement typeElement) {
        String fullQualifiedName = typeElement.getQualifiedName().toString();
        com.github.toolarium.enumeration.configuration.dto.EnumConfiguration enumConfiguration = new com.github.toolarium.enumeration.configuration.dto.EnumConfiguration(fullQualifiedName);
        TypeMirror inheritedEnumConfigurationMarkerInterface = this.processingEnv.getTypeUtils().erasure(this.processingEnv.getElementUtils().getTypeElement(ENUM_CONFIGURATION).asType());
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            boolean bl = this.processingEnv.getTypeUtils().isAssignable(typeMirror, inheritedEnumConfigurationMarkerInterface);
            if (bl) {
                try {
                    enumConfiguration.getMarkerInterfaceList().add(((DeclaredType)typeMirror).asElement().toString());
                }
                catch (Exception ex) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, ex.getMessage());
                }
                continue;
            }
            try {
                enumConfiguration.getInterfaceList().add(((DeclaredType)typeMirror).asElement().toString());
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, ex.getMessage());
            }
        }
        List<? extends AnnotationMirror> annotationElements = typeElement.getAnnotationMirrors();
        if (annotationElements != null) {
            for (AnnotationMirror annotationMirror : annotationElements) {
                if (annotationMirror.getElementValues() == null) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                    String key = AnnotationConvertUtil.getInstance().getName(e.getKey());
                    String value = AnnotationConvertUtil.getInstance().getValue(e.getValue());
                    switch (key) {
                        case "description": {
                            enumConfiguration.setDescription(value);
                            break;
                        }
                        case "validFrom": {
                            enumConfiguration.setValidFrom(DateUtil.getInstance().parseTimestamp(value));
                            break;
                        }
                        case "validTill": {
                            enumConfiguration.setValidTill(DateUtil.getInstance().parseTimestamp(value));
                            break;
                        }
                    }
                }
            }
        }
        return enumConfiguration;
    }

    private EnumKeyConfiguration processEnumKeyConfigurationElement(Element element) {
        EnumKeyConfiguration enumKeyConfiguration = new EnumKeyConfiguration();
        String enumName = "" + element.getSimpleName();
        Object fullQualifiedName = element.toString();
        fullQualifiedName = "" + element.getEnclosingElement();
        fullQualifiedName = (String)fullQualifiedName + "#" + enumName;
        enumKeyConfiguration.setKey(enumName);
        List<? extends AnnotationMirror> annotationElements = element.getAnnotationMirrors();
        if (annotationElements != null) {
            for (AnnotationMirror annotationMirror : annotationElements) {
                if (annotationMirror.getElementValues() == null) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                    String key = AnnotationConvertUtil.getInstance().getName(e.getKey());
                    String value = AnnotationConvertUtil.getInstance().getValue(e.getValue());
                    switch (key) {
                        case "description": {
                            enumKeyConfiguration.setDescription(value.trim());
                            break;
                        }
                        case "isConfidential": {
                            enumKeyConfiguration.setConfidential("true".equalsIgnoreCase(value.trim()));
                            break;
                        }
                        case "validFrom": {
                            enumKeyConfiguration.setValidFrom(DateUtil.getInstance().parseTimestamp(value));
                            break;
                        }
                        case "validTill": {
                            enumKeyConfiguration.setValidTill(DateUtil.getInstance().parseTimestamp(value));
                            break;
                        }
                    }
                }
            }
        }
        try {
            EnumKeyConfigurationValidatorFactory.getInstance().getValidator().validate(enumKeyConfiguration);
        }
        catch (ValidationException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Please check the annotation of " + (String)fullQualifiedName + ": \n" + ex.getMessage());
        }
        return enumKeyConfiguration;
    }

    private EnumKeyValueConfiguration processEnumKeyValueConfigurationElement(Element element) {
        EnumKeyValueConfiguration enumKeyValueConfiguration = new EnumKeyValueConfiguration();
        enumKeyValueConfiguration.setDataType(EnumKeyValueConfigurationDataType.STRING);
        String enumName = "" + element.getSimpleName();
        Object fullQualifiedName = element.toString();
        fullQualifiedName = "" + element.getEnclosingElement();
        fullQualifiedName = (String)fullQualifiedName + "#" + enumName;
        enumKeyValueConfiguration.setKey(enumName);
        String minValueSize = null;
        String maxValueSize = null;
        List<? extends AnnotationMirror> annotationElements = element.getAnnotationMirrors();
        if (annotationElements != null) {
            for (AnnotationMirror annotationMirror : annotationElements) {
                if (annotationMirror.getElementValues() == null) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                    String key = AnnotationConvertUtil.getInstance().getName(e.getKey());
                    String value = AnnotationConvertUtil.getInstance().getValue(e.getValue());
                    switch (key) {
                        case "description": {
                            enumKeyValueConfiguration.setDescription(value.trim());
                            break;
                        }
                        case "dataType": {
                            EnumKeyValueConfigurationDataType type = EnumUtil.getInstance().valueOf(EnumKeyValueConfigurationDataType.class, value);
                            if (type == null) {
                                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid data type [" + e.getValue() + "]! Please check the annoataion of " + (String)fullQualifiedName + ".");
                            }
                            enumKeyValueConfiguration.setDataType(type);
                            break;
                        }
                        case "defaultValue": {
                            enumKeyValueConfiguration.setDefaultValue(value);
                            break;
                        }
                        case "minValue": {
                            minValueSize = value;
                            break;
                        }
                        case "maxValue": {
                            maxValueSize = value;
                            break;
                        }
                        case "exampleValue": {
                            enumKeyValueConfiguration.setExampleValue(value);
                            break;
                        }
                        case "enumerationValue": {
                            enumKeyValueConfiguration.setEnumerationValue(value);
                            break;
                        }
                        case "cardinality": {
                            try {
                                enumKeyValueConfiguration.setCardinality(AnnotationConvertUtil.getInstance().parseCardinality(value));
                            }
                            catch (IllegalArgumentException ex) {
                                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage() + " Please check the annotation of " + (String)fullQualifiedName + ".");
                            }
                            break;
                        }
                        case "uniqueness": {
                            enumKeyValueConfiguration.setUniqueness("true".equalsIgnoreCase(value.trim()));
                            break;
                        }
                        case "isConfidential": {
                            enumKeyValueConfiguration.setConfidential("true".equalsIgnoreCase(value.trim()));
                            break;
                        }
                        case "validFrom": {
                            enumKeyValueConfiguration.setValidFrom(DateUtil.getInstance().parseTimestamp(value));
                            break;
                        }
                        case "validTill": {
                            enumKeyValueConfiguration.setValidTill(DateUtil.getInstance().parseTimestamp(value));
                            break;
                        }
                    }
                }
            }
        }
        try {
            enumKeyValueConfiguration.setValueSize(EnumKeyValueConfigurationValueValidatorFactory.getInstance().createEnumKeyValueConfigurationSizing(enumKeyValueConfiguration.getDataType(), minValueSize, maxValueSize));
        }
        catch (Exception ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage() + " Please check the annotation of " + (String)fullQualifiedName + ".");
        }
        try {
            EnumKeyConfigurationValidatorFactory.getInstance().getValidator().validate(enumKeyValueConfiguration);
        }
        catch (ValidationException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Please check the annotation of " + (String)fullQualifiedName + ": \n" + ex.getMessage());
        }
        return enumKeyValueConfiguration;
    }
}

