/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;

public class EnumKeyValueConfiguration
extends EnumKeyConfiguration {
    private static final long serialVersionUID = -7293637675260240900L;
    private EnumKeyValueConfigurationDataType dataType = EnumKeyValueConfigurationDataType.STRING;
    private String defaultValue = "";
    private String exampleValue = "";
    private String enumerationValue = "";
    private EnumKeyValueConfigurationSizing<?> valueSize = null;
    private EnumKeyValueConfigurationSizing<Integer> cardinality = new EnumKeyValueConfigurationSizing<Integer>(1, 1);
    private boolean uniqueness = false;

    public EnumKeyValueConfigurationDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(EnumKeyValueConfigurationDataType dataType) {
        this.dataType = dataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @JsonIgnore
    public boolean hasDefaultValue() {
        return this.defaultValue != null && !this.defaultValue.isEmpty();
    }

    public String getExampleValue() {
        return this.exampleValue;
    }

    public void setExampleValue(String exampleValue) {
        this.exampleValue = exampleValue;
    }

    public String getEnumerationValue() {
        return this.enumerationValue;
    }

    public void setEnumerationValue(String enumerationValue) {
        this.enumerationValue = enumerationValue;
    }

    public EnumKeyValueConfigurationSizing<?> getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(EnumKeyValueConfigurationSizing<?> valueSize) {
        this.valueSize = valueSize;
    }

    public EnumKeyValueConfigurationSizing<Integer> getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(EnumKeyValueConfigurationSizing<Integer> cardinality) {
        this.cardinality = cardinality;
    }

    @JsonIgnore
    public boolean isMandatory() {
        return this.cardinality != null && this.cardinality.getMinSize() != null && this.cardinality.getMinSize() > 0;
    }

    public boolean uniqueness() {
        return this.uniqueness;
    }

    public void setUniqueness(boolean uniqueness) {
        this.uniqueness = uniqueness;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result;
        if (this.dataType != null) {
            result += this.dataType.hashCode();
        }
        result = 31 * result;
        if (this.defaultValue != null) {
            result += this.defaultValue.hashCode();
        }
        result = 31 * result;
        if (this.exampleValue != null) {
            result += this.exampleValue.hashCode();
        }
        result = 31 * result;
        if (this.enumerationValue != null) {
            result += this.enumerationValue.hashCode();
        }
        result = 31 * result;
        if (this.valueSize != null) {
            result += this.valueSize.hashCode();
        }
        result = 31 * result;
        if (this.cardinality != null) {
            result += this.cardinality.hashCode();
        }
        result = 31 * result;
        result = this.uniqueness ? (result += 1231) : (result += 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumKeyValueConfiguration other = (EnumKeyValueConfiguration)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.exampleValue == null ? other.exampleValue != null : !this.exampleValue.equals(other.exampleValue)) {
            return false;
        }
        if (this.enumerationValue == null ? other.enumerationValue != null : !this.enumerationValue.equals(other.enumerationValue)) {
            return false;
        }
        if (this.valueSize == null ? other.valueSize != null : !this.valueSize.equals(other.valueSize)) {
            return false;
        }
        if (this.cardinality == null ? other.cardinality != null : !this.cardinality.equals(other.cardinality)) {
            return false;
        }
        return this.uniqueness == other.uniqueness;
    }

    @Override
    public String toString() {
        return "EnumKeyValueConfiguration [key=" + this.getKey() + ", dataType=" + this.getDataType() + ", description=" + this.getDescription() + ", defaultValue=" + this.getDefaultValue() + ", exampleValue=" + this.getExampleValue() + ", enumerationValue=" + this.getEnumerationValue() + ", valueSize=" + this.getValueSize() + ", cardinality=" + this.getCardinality() + ", uniqueness=" + this.uniqueness() + ", mandatory=" + this.isMandatory() + ", confidential=" + this.isConfidential() + ", validFrom=" + this.getValidFrom() + ", validTill=" + this.getValidTill() + "]";
    }
}

