/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.toolarium.enumeration.configuration.dto.EnumConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class EnumConfigurations
implements Serializable {
    private static final long serialVersionUID = 8595845598162960442L;
    private String name = "toolarium-enum-configuration";
    private String version = "0.9.9";
    private Map<String, EnumConfiguration<? extends EnumKeyConfiguration>> enumConfigurationContentMap = new LinkedHashMap<String, EnumConfiguration<? extends EnumKeyConfiguration>>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public EnumConfiguration<? extends EnumKeyConfiguration> get(String name) {
        if (name == null) {
            return null;
        }
        return this.enumConfigurationContentMap.get(name.trim());
    }

    public Set<EnumConfiguration<? extends EnumKeyConfiguration>> getEnumConfigurationList() {
        LinkedHashSet<EnumConfiguration<? extends EnumKeyConfiguration>> result = new LinkedHashSet<EnumConfiguration<? extends EnumKeyConfiguration>>();
        for (Map.Entry<String, EnumConfiguration<? extends EnumKeyConfiguration>> e : this.enumConfigurationContentMap.entrySet()) {
            result.add(e.getValue());
        }
        return result;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setEnumConfigurationList(Set<EnumConfiguration<? extends EnumKeyConfiguration>> list) {
        this.enumConfigurationContentMap = new LinkedHashMap<String, EnumConfiguration<? extends EnumKeyConfiguration>>();
        for (EnumConfiguration<? extends EnumKeyConfiguration> e : list) {
            this.add(e);
        }
    }

    public EnumConfiguration<? extends EnumKeyConfiguration> add(EnumConfiguration<? extends EnumKeyConfiguration> enumConfiguration) {
        if (enumConfiguration == null || enumConfiguration.getName() == null || enumConfiguration.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid enum configuration:" + enumConfiguration);
        }
        String name = enumConfiguration.getName().trim();
        if (!this.enumConfigurationContentMap.containsKey(name)) {
            this.enumConfigurationContentMap.put(name, enumConfiguration);
            return enumConfiguration;
        }
        return null;
    }

    public Set<EnumConfiguration<? extends EnumKeyConfiguration>> selectMandatoryConfigurationList() {
        LinkedHashSet<EnumConfiguration<? extends EnumKeyConfiguration>> result = new LinkedHashSet<EnumConfiguration<? extends EnumKeyConfiguration>>();
        for (Map.Entry<String, EnumConfiguration<? extends EnumKeyConfiguration>> e : this.enumConfigurationContentMap.entrySet()) {
            Set<? extends EnumKeyConfiguration> enumKeyConfigurationList = e.getValue().selectMandatoryConfigurationList();
            if (enumKeyConfigurationList == null || enumKeyConfigurationList.isEmpty()) continue;
            EnumConfiguration enumConfigurationToAdd = new EnumConfiguration();
            enumConfigurationToAdd.setDescription(e.getValue().getDescription());
            enumConfigurationToAdd.setValidFrom(e.getValue().getValidFrom());
            enumConfigurationToAdd.setValidTill(e.getValue().getValidTill());
            enumConfigurationToAdd.setName(e.getValue().getName());
            enumConfigurationToAdd.setInterfaceList(e.getValue().getInterfaceList());
            enumConfigurationToAdd.setMarkerInterfaceList(e.getValue().getMarkerInterfaceList());
            enumConfigurationToAdd.setKeyList(enumKeyConfigurationList);
            result.add(enumConfigurationToAdd);
        }
        return result;
    }

    public Set<EnumConfiguration<? extends EnumKeyConfiguration>> selectMandatoryConfigurationListWithMissingDefaultValue() {
        LinkedHashSet<EnumConfiguration<? extends EnumKeyConfiguration>> result = new LinkedHashSet<EnumConfiguration<? extends EnumKeyConfiguration>>();
        for (Map.Entry<String, EnumConfiguration<? extends EnumKeyConfiguration>> e : this.enumConfigurationContentMap.entrySet()) {
            Set<? extends EnumKeyConfiguration> enumKeyConfigurationList = e.getValue().selectMandatoryListWithMissingDefaultValue();
            if (enumKeyConfigurationList == null || enumKeyConfigurationList.isEmpty()) continue;
            EnumConfiguration enumConfigurationToAdd = new EnumConfiguration();
            enumConfigurationToAdd.setDescription(e.getValue().getDescription());
            enumConfigurationToAdd.setValidFrom(e.getValue().getValidFrom());
            enumConfigurationToAdd.setValidTill(e.getValue().getValidTill());
            enumConfigurationToAdd.setName(e.getValue().getName());
            enumConfigurationToAdd.setInterfaceList(e.getValue().getInterfaceList());
            enumConfigurationToAdd.setMarkerInterfaceList(e.getValue().getMarkerInterfaceList());
            enumConfigurationToAdd.setKeyList(enumKeyConfigurationList);
            result.add(enumConfigurationToAdd);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.name != null) {
            result += this.name.hashCode();
        }
        result = 31 * result;
        if (this.version != null) {
            result += this.version.hashCode();
        }
        result = 31 * result;
        if (this.enumConfigurationContentMap != null) {
            result += this.enumConfigurationContentMap.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumConfigurations other = (EnumConfigurations)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.enumConfigurationContentMap == null ? other.enumConfigurationContentMap != null : !this.enumConfigurationContentMap.equals(other.enumConfigurationContentMap));
    }

    public String toString() {
        return "EnumConfigurations [name=" + this.name + ", version=" + this.version + ", enumConfigurationList=" + this.getEnumConfigurationList() + "]";
    }
}

