/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.toolarium.enumeration.configuration.dto.AbstractEnumConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyConfiguration;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfiguration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class EnumConfiguration<T extends EnumKeyConfiguration>
extends AbstractEnumConfiguration {
    public static final String MAX_TIMESTAMP_STRING = "9999-12-31T12:00:00.000Z";
    public static final String MAX_DATE_STRING = "9999-12-31";
    public static final String MAX_TIME_STRING = "23:59:59.999";
    private static final long serialVersionUID = -5016414165364299512L;
    private String name = null;
    private Map<String, T> keyList = new LinkedHashMap<String, T>();
    private Set<String> interfaceList = new LinkedHashSet<String>();
    private Set<String> markerInterfaceList = new LinkedHashSet<String>();

    public EnumConfiguration() {
    }

    public EnumConfiguration(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public <K extends EnumKeyConfiguration> void setKeyList(Set<K> keyList) {
        this.keyList = new LinkedHashMap<String, T>();
        if (keyList != null) {
            for (EnumKeyConfiguration k : keyList) {
                this.add(k);
            }
        }
    }

    public Set<T> getKeyList() {
        LinkedHashSet<EnumKeyConfiguration> result = new LinkedHashSet<EnumKeyConfiguration>();
        for (Map.Entry<String, T> e : this.keyList.entrySet()) {
            result.add((EnumKeyConfiguration)e.getValue());
        }
        return result;
    }

    public void setInterfaceList(Set<String> interfaceList) {
        this.interfaceList = interfaceList;
    }

    public Set<String> getInterfaceList() {
        return this.interfaceList;
    }

    public void setMarkerInterfaceList(Set<String> markerInterfaceList) {
        this.markerInterfaceList = markerInterfaceList;
    }

    public Set<String> getMarkerInterfaceList() {
        return this.markerInterfaceList;
    }

    public T add(T enumKeyConfiguration) {
        String key;
        if (enumKeyConfiguration == null || ((EnumKeyConfiguration)enumKeyConfiguration).getKey() == null || ((EnumKeyConfiguration)enumKeyConfiguration).getKey().trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid enum value configuration:" + enumKeyConfiguration);
        }
        if (((AbstractEnumConfiguration)enumKeyConfiguration).getValidFrom() == null || this.getValidFrom().isAfter(((AbstractEnumConfiguration)enumKeyConfiguration).getValidFrom())) {
            ((AbstractEnumConfiguration)enumKeyConfiguration).setValidFrom(this.getValidFrom());
        }
        if (((AbstractEnumConfiguration)enumKeyConfiguration).getValidTill() == null || this.getValidTill().isBefore(((AbstractEnumConfiguration)enumKeyConfiguration).getValidTill())) {
            ((AbstractEnumConfiguration)enumKeyConfiguration).setValidTill(this.getValidTill());
        }
        if (!this.keyList.containsKey(key = ((EnumKeyConfiguration)enumKeyConfiguration).getKey().trim())) {
            this.keyList.put(key, enumKeyConfiguration);
            return enumKeyConfiguration;
        }
        return null;
    }

    public Set<T> selectMandatoryConfigurationList() {
        LinkedHashSet<EnumKeyConfiguration> result = new LinkedHashSet<EnumKeyConfiguration>();
        for (Map.Entry<String, T> e : this.keyList.entrySet()) {
            if (EnumKeyValueConfiguration.class.isInstance(e.getValue())) {
                if (!((EnumKeyValueConfiguration)e.getValue()).isMandatory()) continue;
                result.add((EnumKeyConfiguration)e.getValue());
                continue;
            }
            result.add((EnumKeyConfiguration)e.getValue());
        }
        return result;
    }

    public Set<T> selectMandatoryListWithMissingDefaultValue() {
        LinkedHashSet<EnumKeyConfiguration> result = new LinkedHashSet<EnumKeyConfiguration>();
        for (Map.Entry<String, T> e : this.keyList.entrySet()) {
            if (!EnumKeyValueConfiguration.class.isInstance(e.getValue()) || !((EnumKeyValueConfiguration)e.getValue()).isMandatory() || ((EnumKeyValueConfiguration)e.getValue()).hasDefaultValue()) continue;
            result.add((EnumKeyConfiguration)e.getValue());
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result;
        if (this.name != null) {
            result += this.name.hashCode();
        }
        result = 31 * result;
        if (this.keyList != null) {
            result += this.keyList.hashCode();
        }
        result = 31 * result;
        if (this.interfaceList != null) {
            result += this.interfaceList.hashCode();
        }
        result = 31 * result;
        if (this.markerInterfaceList != null) {
            result += this.markerInterfaceList.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumConfiguration other = (EnumConfiguration)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.keyList == null ? other.keyList != null : !this.keyList.equals(other.keyList)) {
            return false;
        }
        if (this.interfaceList == null ? other.interfaceList != null : !this.interfaceList.equals(other.interfaceList)) {
            return false;
        }
        return !(this.markerInterfaceList == null ? other.markerInterfaceList != null : !this.markerInterfaceList.equals(other.markerInterfaceList));
    }

    public String toString() {
        return "EnumConfiguration [name=" + this.name + ", description=" + this.getDescription() + ", validFrom=" + this.getValidFrom() + ", validTill=" + this.getValidTill() + ", keyList=" + this.getKeyList() + ", interfaceList=" + this.getInterfaceList() + ", markerInterfaceList=" + this.getMarkerInterfaceList() + "]";
    }
}

