/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.converter.impl;

import com.github.toolarium.enumeration.configuration.converter.IStringTypeConverter;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationBinaryObject;
import com.github.toolarium.enumeration.configuration.util.CIDRUtil;
import com.github.toolarium.enumeration.configuration.util.DateUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class AbstractStringTypeConverter
implements IStringTypeConverter {
    protected static final String HEX_WEBCOLOR_PATTERN = "^#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$";
    protected static final Pattern hexWebColorPattern = Pattern.compile("^#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$");

    protected String checkBase(String value) {
        if (value == null) {
            return null;
        }
        String exp = value.trim();
        if (exp.length() == 0) {
            return null;
        }
        return exp;
    }

    protected Long getNumber(String input) throws NumberFormatException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    protected Double getDouble(String input) throws NumberFormatException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    protected Boolean getBoolean(String input) throws IllegalArgumentException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        if ("yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid value: [" + input + "].");
    }

    protected LocalDate getDate(String input) throws DateTimeParseException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        return LocalDate.parse(value);
    }

    protected LocalTime getTime(String input) throws DateTimeParseException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        return LocalTime.parse(value);
    }

    protected Instant getTimestamp(String input) throws DateTimeParseException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        return Instant.parse(value);
    }

    protected String getRegExp(String input) throws PatternSyntaxException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        Pattern.compile(value);
        return value;
    }

    protected UUID getUUID(String input) throws IllegalArgumentException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        return UUID.fromString(value);
    }

    protected URI getURI(String input) throws URISyntaxException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        return new URI(value);
    }

    protected String getCIDR(String input) throws URISyntaxException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        if (!CIDRUtil.getInstance().isValidRange(value)) {
            throw new IllegalArgumentException("Invalid value: [" + input + "].");
        }
        return value;
    }

    protected String getEmail(String input) throws IllegalArgumentException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        String[] split = value.split("@");
        if (split == null || split.length < 2) {
            throw new IllegalArgumentException("Invalid value: [" + input + "].");
        }
        return value;
    }

    protected String getCron(String input) throws IllegalArgumentException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        String[] cronSplit = value.split(" ");
        if (cronSplit.length < 5) {
            throw new IllegalArgumentException("Invalid cron entry [" + input + "]!");
        }
        return value;
    }

    protected String getColor(String input) throws IllegalArgumentException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        Matcher matcher = hexWebColorPattern.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid value: [" + input + "].");
        }
        return value;
    }

    protected String getCertificate(String input) throws IllegalArgumentException {
        String value = this.checkBase(input);
        if (value == null) {
            return null;
        }
        if (value.length() < 16) {
            throw new IllegalArgumentException("Invalid value: [" + input + "].");
        }
        return value;
    }

    protected EnumKeyValueConfigurationBinaryObject getBinary(String input) throws IllegalArgumentException {
        if (this.checkBase(input) == null) {
            return null;
        }
        EnumKeyValueConfigurationBinaryObject result = new EnumKeyValueConfigurationBinaryObject();
        if (input.indexOf(124) < 0) {
            result.setData(input);
            return result;
        }
        String[] binaryData = input.split("\\|");
        if (binaryData.length <= 1) {
            result.setData(input);
        } else {
            result.setName(binaryData[0]);
            if (binaryData.length > 2) {
                if (binaryData[1] != null && !binaryData[1].trim().isEmpty()) {
                    try {
                        result.setTimestamp(DateUtil.getInstance().parseTimestamp(binaryData[1]));
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Invalid timestamp [" + binaryData[1] + "]!");
                    }
                }
                if (binaryData.length > 3) {
                    result.setMimetype(binaryData[2].trim());
                }
            }
            result.setData(binaryData[binaryData.length - 1]);
        }
        return result;
    }
}

