/**
 * Logback: the reliable, generic, fast and flexible logging framework.
 * Copyright (C) 1999-2015, QOS.ch. All rights reserved.
 *
 * This program and the accompanying materials are dual-licensed under
 * either the terms of the Eclipse Public License v1.0 as published by
 * the Eclipse Foundation
 *
 *   or (per the licensee's choosing)
 *
 * under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation.
 */
package org.apache.juli.logging.ch.qos.logback.classic.sift;

import org.apache.juli.logging.ch.qos.logback.classic.ClassicConstants;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.DefaultClass;
import org.apache.juli.logging.ch.qos.logback.core.sift.Discriminator;
import org.apache.juli.logging.ch.qos.logback.core.sift.SiftingAppenderBase;

import java.util.List;

import org.apache.juli.logging.org.slf4j.Marker;

/**
 * This appender can contain other appenders which it can build dynamically
 * depending on MDC values. The built appender is specified as part of a
 * configuration file.
 * 
 * <p>See the logback manual for further details.
 * 
 * 
 * @author Ceki Gulcu
 */
public class SiftingAppender extends SiftingAppenderBase<ILoggingEvent> {

    @Override
    protected long getTimestamp(ILoggingEvent event) {
        return event.getTimeStamp();
    }

    @Override
    @DefaultClass(MDCBasedDiscriminator.class)
    public void setDiscriminator(Discriminator<ILoggingEvent> discriminator) {
        super.setDiscriminator(discriminator);
    }

    protected boolean eventMarksEndOfLife(ILoggingEvent event) {
        List<Marker> markers = event.getMarkerList();
        if (markers == null)
            return false;

        for(Marker m: markers) {
            if(m.contains(ClassicConstants.FINALIZE_SESSION_MARKER))
                return true;
        }
        return false;
    }
}
