/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.ch.qos.logback.classic.joran;

import org.apache.juli.logging.ch.qos.logback.classic.joran.action.ConfigurationAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.ConsolePluginAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.ContextNameAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.InsertFromJNDIAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.LevelAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.LoggerAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.LoggerContextListenerAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.ReceiverAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.action.RootLoggerAction;
import org.apache.juli.logging.ch.qos.logback.classic.joran.sanity.IfNestedWithinSecondPhaseElementSC;
import org.apache.juli.logging.ch.qos.logback.classic.model.ConfigurationModel;
import org.apache.juli.logging.ch.qos.logback.classic.model.ContextNameModel;
import org.apache.juli.logging.ch.qos.logback.classic.model.LevelModel;
import org.apache.juli.logging.ch.qos.logback.classic.model.LoggerContextListenerModel;
import org.apache.juli.logging.ch.qos.logback.classic.model.LoggerModel;
import org.apache.juli.logging.ch.qos.logback.classic.model.RootLoggerModel;
import org.apache.juli.logging.ch.qos.logback.classic.model.processor.ConfigurationModelHandler;
import org.apache.juli.logging.ch.qos.logback.classic.model.processor.ContextNameModelHandler;
import org.apache.juli.logging.ch.qos.logback.classic.model.processor.LevelModelHandler;
import org.apache.juli.logging.ch.qos.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import org.apache.juli.logging.ch.qos.logback.classic.model.processor.LoggerContextListenerModelHandler;
import org.apache.juli.logging.ch.qos.logback.classic.model.processor.LoggerModelHandler;
import org.apache.juli.logging.ch.qos.logback.classic.model.processor.RootLoggerModelHandler;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.ch.qos.logback.core.joran.JoranConfiguratorBase;
import org.apache.juli.logging.ch.qos.logback.core.joran.action.AppenderRefAction;
import org.apache.juli.logging.ch.qos.logback.core.joran.action.IncludeAction;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.ElementSelector;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.RuleStore;
import org.apache.juli.logging.ch.qos.logback.core.model.AppenderModel;
import org.apache.juli.logging.ch.qos.logback.core.model.AppenderRefModel;
import org.apache.juli.logging.ch.qos.logback.core.model.InsertFromJNDIModel;
import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.AppenderModelHandler;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.AppenderRefDependencyAnalyser;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.AppenderRefModelHandler;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.DefaultProcessor;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.InsertFromJNDIModelHandler;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.RefContainerDependencyAnalyser;

public class JoranConfigurator
extends JoranConfiguratorBase<ILoggingEvent> {
    @Override
    public void addElementSelectorAndActionAssociations(RuleStore rs) {
        super.addElementSelectorAndActionAssociations(rs);
        rs.addRule(new ElementSelector("configuration"), () -> new ConfigurationAction());
        rs.addRule(new ElementSelector("configuration/contextName"), () -> new ContextNameAction());
        rs.addRule(new ElementSelector("configuration/contextListener"), () -> new LoggerContextListenerAction());
        rs.addRule(new ElementSelector("configuration/insertFromJNDI"), () -> new InsertFromJNDIAction());
        rs.addRule(new ElementSelector("configuration/logger"), () -> new LoggerAction());
        rs.addRule(new ElementSelector("configuration/logger/level"), () -> new LevelAction());
        rs.addRule(new ElementSelector("configuration/root"), () -> new RootLoggerAction());
        rs.addRule(new ElementSelector("configuration/root/level"), () -> new LevelAction());
        rs.addRule(new ElementSelector("configuration/logger/appender-ref"), () -> new AppenderRefAction());
        rs.addRule(new ElementSelector("configuration/root/appender-ref"), () -> new AppenderRefAction());
        rs.addRule(new ElementSelector("configuration/include"), () -> new IncludeAction());
        rs.addRule(new ElementSelector("configuration/consolePlugin"), () -> new ConsolePluginAction());
        rs.addRule(new ElementSelector("configuration/receiver"), () -> new ReceiverAction());
    }

    @Override
    protected void sanityCheck(Model topModel) {
        super.sanityCheck(topModel);
        this.performCheck(new IfNestedWithinSecondPhaseElementSC(), topModel);
    }

    @Override
    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry registry) {
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules(registry);
    }

    @Override
    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        super.addModelHandlerAssociations(defaultProcessor);
        defaultProcessor.addHandler(ConfigurationModel.class, ConfigurationModelHandler::makeInstance);
        defaultProcessor.addHandler(ContextNameModel.class, ContextNameModelHandler::makeInstance);
        defaultProcessor.addHandler(LoggerContextListenerModel.class, LoggerContextListenerModelHandler::makeInstance);
        defaultProcessor.addHandler(InsertFromJNDIModel.class, InsertFromJNDIModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderModel.class, AppenderModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderRefModel.class, AppenderRefModelHandler::makeInstance);
        defaultProcessor.addHandler(RootLoggerModel.class, RootLoggerModelHandler::makeInstance);
        defaultProcessor.addHandler(LoggerModel.class, LoggerModelHandler::makeInstance);
        defaultProcessor.addHandler(LevelModel.class, LevelModelHandler::makeInstance);
        defaultProcessor.addAnalyser(LoggerModel.class, () -> new RefContainerDependencyAnalyser(this.context, LoggerModel.class));
        defaultProcessor.addAnalyser(RootLoggerModel.class, () -> new RefContainerDependencyAnalyser(this.context, RootLoggerModel.class));
        defaultProcessor.addAnalyser(AppenderModel.class, () -> new RefContainerDependencyAnalyser(this.context, AppenderModel.class));
        defaultProcessor.addAnalyser(AppenderRefModel.class, () -> new AppenderRefDependencyAnalyser(this.context));
        this.sealModelFilters(defaultProcessor);
    }

    private void sealModelFilters(DefaultProcessor defaultProcessor) {
        defaultProcessor.getPhaseOneFilter().denyAll();
        defaultProcessor.getPhaseTwoFilter().allowAll();
    }
}

