package org.apache.juli.logging.ch.qos.logback.core.joran;

import org.apache.juli.logging.ch.qos.logback.core.Context;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.InterpretationContext;
import org.apache.juli.logging.ch.qos.logback.core.joran.util.PropertySetter;
import org.apache.juli.logging.ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.model.ParamModel;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerBase;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerException;

public class ParamModelHandler extends ModelHandlerBase {

	private final BeanDescriptionCache beanDescriptionCache;

	public ParamModelHandler(Context context, BeanDescriptionCache beanDescriptionCache) {
		super(context);
		this.beanDescriptionCache = beanDescriptionCache;
	}

	@Override
	protected Class<ParamModel> getSupportedModelClass() {
		return ParamModel.class;
	}

	@Override
	public void handle(InterpretationContext intercon, Model model) throws ModelHandlerException {

		ParamModel paramModel = (ParamModel) model;

		String valueStr = intercon.subst(paramModel.getValue());

		Object o = intercon.peekObject();

		PropertySetter propSetter = new PropertySetter(beanDescriptionCache, o);
		propSetter.setContext(context);

		// allow for variable substitution for name as well
		String finalName = intercon.subst(paramModel.getName());
	     propSetter.setProperty(finalName, valueStr);
	}

}
