package org.apache.juli.logging.ch.qos.logback.classic.model.processor;

import org.apache.juli.logging.ch.qos.logback.classic.LoggerContext;
import org.apache.juli.logging.ch.qos.logback.classic.model.LoggerContextListenerModel;
import org.apache.juli.logging.ch.qos.logback.classic.spi.LoggerContextListener;
import org.apache.juli.logging.ch.qos.logback.core.Context;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.InterpretationContext;
import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerBase;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerException;
import org.apache.juli.logging.ch.qos.logback.core.spi.ContextAware;
import org.apache.juli.logging.ch.qos.logback.core.spi.LifeCycle;
import org.apache.juli.logging.ch.qos.logback.core.util.OptionHelper;

public class LoggerContextListenerModelHandler extends ModelHandlerBase {
	boolean inError = false;
	LoggerContextListener lcl;

	public LoggerContextListenerModelHandler(Context context) {
		super(context);
	}

	@Override
	protected Class<LoggerContextListenerModel> getSupportedModelClass() {
		return LoggerContextListenerModel.class;
	}

	@Override
	public void handle(InterpretationContext intercon, Model model) throws ModelHandlerException {
		LoggerContextListenerModel LoggerContextListenerModel = (LoggerContextListenerModel) model;

		String className = LoggerContextListenerModel.getClassName();
		try {
			lcl = (LoggerContextListener) OptionHelper.instantiateByClassName(className, LoggerContextListener.class,
					context);

			if (lcl instanceof ContextAware) {
				((ContextAware) lcl).setContext(context);
			}

			intercon.pushObject(lcl);
			addInfo("Adding LoggerContextListener of type [" + className + "] to the object stack");

		} catch (Exception oops) {
			inError = true;
			addError("Could not create LoggerContextListener of type " + className + "].", oops);
		}
	}

	@Override
	public void postHandle(InterpretationContext interop, Model model) throws ModelHandlerException {
		if (inError) {
			return;
		}
		Object o = interop.peekObject();

		if (o != lcl) {
			addWarn("The object on the top the of the stack is not the LoggerContextListener pushed earlier.");
		} else {
			if (lcl instanceof LifeCycle) {
				((LifeCycle) lcl).start();
				addInfo("Starting LoggerContextListener");
			}
			((LoggerContext) context).addListener(lcl);
			interop.popObject();
		}
	}
}
