/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.cli.progress;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;

class StreamHandler {
    private static boolean replaced;
    private static ByteArrayOutputStream stdOutBuffer;
    private static ByteArrayOutputStream stdErrBuffer;
    private static PrintStream sysOut;
    private static PrintStream sysErr;

    StreamHandler() {
    }

    static synchronized Replace replace(boolean replaceOut, boolean replaceErr, Consumer<PrintStream> setter) {
        if (replaced) {
            setter.accept(System.out);
            return Replace.IMPOSSIBLE;
        }
        sysOut = System.out;
        sysErr = System.err;
        if (replaceOut) {
            System.setOut(new PrintStream(stdOutBuffer));
        }
        if (replaceErr) {
            System.setErr(new PrintStream(stdErrBuffer));
        }
        setter.accept(sysOut);
        replaced = replaceOut || replaceErr;
        return replaced ? Replace.DONE : Replace.NOT_REPLACED;
    }

    static synchronized void replaceBack(Replace replace) {
        switch (replace) {
            case IMPOSSIBLE: 
            case NOT_REPLACED: {
                return;
            }
        }
        if (!replaced) {
            return;
        }
        System.setOut(sysOut);
        System.setErr(sysErr);
        if (stdOutBuffer.size() > 0) {
            System.out.println(new String(stdOutBuffer.toByteArray()));
        }
        if (stdErrBuffer.size() > 0) {
            System.err.println(new String(stdErrBuffer.toByteArray()));
        }
        sysOut = null;
        sysErr = null;
        stdOutBuffer = new ByteArrayOutputStream();
        stdErrBuffer = new ByteArrayOutputStream();
        replaced = false;
    }

    static {
        stdOutBuffer = new ByteArrayOutputStream();
        stdErrBuffer = new ByteArrayOutputStream();
    }

    static enum Replace {
        IMPOSSIBLE,
        DONE,
        NOT_REPLACED;

    }
}

