/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.cli.progress;

import com.github.tomaslanger.chalk.Ansi;
import com.github.tomaslanger.chalk.Chalk;
import com.github.tomaslanger.cli.progress.ProgressBar;
import com.github.tomaslanger.cli.progress.ProgressBarBase;
import com.github.tomaslanger.cli.progress.StatusLoc;
import java.io.PrintStream;

public class ProgressBarMasterDetail
extends ProgressBarBase {
    private final ProgressBar.Builder childBulder;
    private PrintStream out;
    private boolean isBatch;
    private ProgressBar master;
    private ProgressBar child;
    private int currentTaskProgress;
    private int overallProgress;

    protected ProgressBarMasterDetail(Builder builder) {
        super(builder);
        this.isBatch = builder.isBatch() || !Chalk.isCommandEnabled();
        ProgressBar.Builder masterBuilder = builder.getMasterPbBuilder();
        if (this.isBatch) {
            masterBuilder.setBatch();
        }
        this.master = masterBuilder.build();
        this.childBulder = builder.getChildPbBuilder();
    }

    public void nextTask(int max, String infoText) {
        super.checkSetProgress();
        this.overallProgress += this.currentTaskProgress;
        this.currentTaskProgress = 0;
        if (this.isBatch) {
            return;
        }
        if (null == this.child) {
            this.out.println();
        } else {
            this.child.setStatus(null);
            this.child.end();
            this.out.print(Ansi.cursorUp((int)2));
            this.out.print('\r');
        }
        this.child = this.childBulder.setMax(max).build();
        this.child.begin(this.out);
        this.child.setProgress(0, infoText);
    }

    public void setProgress(int currentTaskProgress, String infoText) {
        super.checkSetProgress();
        this.currentTaskProgress = currentTaskProgress;
        if (!this.isBatch) {
            this.out.print(Ansi.cursorUp((int)2));
        }
        this.master.setProgress(this.overallProgress + this.currentTaskProgress);
        if (!this.isBatch) {
            this.out.print(Ansi.cursorDown((int)2));
            this.child.setProgress(currentTaskProgress, infoText);
        }
    }

    @Override
    protected void finishProgressBar(boolean isCancel) {
        this.out.println();
    }

    @Override
    protected void initProgressBar() {
        this.master.begin(this.out);
        this.master.setProgress(0);
    }

    @Override
    protected void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    public static class Builder
    extends ProgressBarBase.Builder<Builder> {
        private ProgressBar.Builder masterPbBuilder;
        private ProgressBar.Builder childPbBuilder;

        public Builder setMasterPbBuilder(ProgressBar.Builder masterPbBuilder) {
            this.masterPbBuilder = masterPbBuilder;
            return this;
        }

        public Builder setChildPbBuilder(ProgressBar.Builder childPbBuilder) {
            this.childPbBuilder = childPbBuilder;
            return this;
        }

        private ProgressBar.Builder getMasterPbBuilder() {
            return this.masterPbBuilder;
        }

        private ProgressBar.Builder getChildPbBuilder() {
            return this.childPbBuilder;
        }

        public ProgressBarMasterDetail build() {
            ((ProgressBar.Builder)this.masterPbBuilder.claimNoOuts()).setStatusLocation(StatusLoc.SAME_LINE);
            ((ProgressBar.Builder)this.childPbBuilder.claimNoOuts()).setStatusLocation(StatusLoc.FIRST_LINE);
            return new ProgressBarMasterDetail(this);
        }
    }
}

