/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.cli.progress;

import com.github.tomaslanger.chalk.Ansi;
import com.github.tomaslanger.chalk.Chalk;
import com.github.tomaslanger.cli.progress.ProgressBar;
import com.github.tomaslanger.cli.progress.StatusLoc;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Set;

class ProgressBarInPlace
extends ProgressBar {
    private static final String THREE_SPACES = "   ";
    private final StringBuilder textToPrint = new StringBuilder();
    private final boolean keepSingleColor;
    private final boolean shouldPrintPercents;
    private final Ansi.Color statusColor;
    private final Ansi.BgColor statusBgColor;
    private final Set<Ansi.Modifier> statusModifiers = EnumSet.noneOf(Ansi.Modifier.class);
    private final StatusLoc statusLocation;
    private int printedChars;
    private String statusTextOnScreen;
    private int wantedPercentage;
    private int printedPercentage;
    private boolean isVisible;

    protected ProgressBarInPlace(ProgressBar.Builder builder) {
        super(builder);
        this.keepSingleColor = builder.shouldKeepSingleColor();
        this.shouldPrintPercents = builder.shouldPrintPercents();
        this.statusColor = builder.getStatusColor();
        this.statusBgColor = builder.getStatusBgColor();
        this.statusModifiers.addAll(builder.getStatusModifiers());
        this.statusLocation = builder.getStatusLocation();
    }

    @Override
    protected void printBar(PrintStream out, int progress) {
        int shouldPrintChars = progress * this.charCount / this.max;
        if (this.shouldPrintPercents) {
            this.wantedPercentage = progress * 100 / this.max;
            if (this.wantedPercentage == 100 && progress != this.max) {
                this.wantedPercentage = 99;
            }
        }
        if (!this.requiresUpdate(shouldPrintChars)) {
            return;
        }
        if (this.keepSingleColor) {
            StringBuilder colorless = new StringBuilder(shouldPrintChars);
            for (int i = 0; i < shouldPrintChars; ++i) {
                colorless.append(this.progressChar);
            }
            this.textToPrint.setLength(0);
            this.textToPrint.append(this.chalked(colorless.toString()));
        } else {
            if (shouldPrintChars > this.printedChars) {
                for (int i = this.printedChars; i < shouldPrintChars; ++i) {
                    this.textToPrint.append(this.chalked(this.progressChar));
                }
            }
            if (shouldPrintChars < this.printedChars) {
                this.textToPrint.delete(this.textToPrint.length() - (this.printedChars - shouldPrintChars), this.textToPrint.length());
            }
        }
        this.printProgressBar(out, shouldPrintChars);
        this.printedChars = shouldPrintChars;
    }

    private boolean requiresUpdate(int shouldPrintChars) {
        if (shouldPrintChars != this.printedChars) {
            return true;
        }
        if (this.statusChanged()) {
            return true;
        }
        if (!this.isVisible) {
            return true;
        }
        return this.shouldPrintPercents && this.wantedPercentage != this.printedPercentage;
    }

    @Override
    protected void printBarHeader(PrintStream out) {
    }

    @Override
    protected void printBarEnd(PrintStream out) {
        out.println();
        this.textToPrint.setLength(0);
        this.printedChars = 0;
        this.statusTextOnScreen = null;
    }

    @Override
    protected void printCancel(PrintStream out) {
        out.println();
    }

    private boolean statusChanged() {
        if (this.wantedStatus == this.statusTextOnScreen) {
            return false;
        }
        if (null == this.statusTextOnScreen || null == this.wantedStatus) {
            return true;
        }
        return !this.statusTextOnScreen.equals(this.wantedStatus);
    }

    private void printProgressBar(PrintStream out, int shouldPrintChars) {
        if (this.isVisible) {
            if (this.statusLocation != StatusLoc.SAME_LINE) {
                out.print(Ansi.cursorUp());
            }
            out.print('\r');
        }
        if (this.statusLocation == StatusLoc.FIRST_LINE) {
            this.printStatus(out);
            out.println();
        }
        out.print(this.beginString);
        out.print(this.textToPrint);
        for (int i = shouldPrintChars; i < this.charCount; ++i) {
            out.print(this.baseChar);
        }
        out.print(this.endString);
        if (this.shouldPrintPercents) {
            out.print(this.formatPercentage());
            this.printedPercentage = this.wantedPercentage;
        }
        if (this.statusLocation == StatusLoc.SAME_LINE) {
            out.print(' ');
            this.printStatus(out);
        } else if (this.statusLocation == StatusLoc.LAST_LINE) {
            out.println();
            this.printStatus(out);
        }
        out.flush();
        this.isVisible = true;
    }

    private void printStatus(PrintStream out) {
        if (this.wantedStatus != null) {
            out.print(this.statusChalked(this.wantedStatus));
        }
        int toPrint = this.charDif(this.statusTextOnScreen, this.wantedStatus);
        for (int i = 0; i < toPrint; ++i) {
            out.print(" ");
        }
        this.statusTextOnScreen = this.wantedStatus;
    }

    private String formatPercentage() {
        if (this.wantedPercentage > 100) {
            this.wantedPercentage = 100;
        }
        String result = this.wantedPercentage + "%";
        String spaces = THREE_SPACES.substring(result.length() - 2);
        return spaces + this.statusChalked(result);
    }

    private int charDif(String printedStatus, String statusText) {
        if (null == printedStatus) {
            return 0;
        }
        if (null == statusText) {
            return printedStatus.length() + 1;
        }
        return printedStatus.length() - statusText.length();
    }

    protected Chalk statusChalked(String toChalk) {
        return this.statusChalked(Chalk.on((String)String.valueOf(toChalk)));
    }

    private Chalk statusChalked(Chalk toChalk) {
        if (null != this.statusColor) {
            toChalk.apply((Ansi.AnsiCode)this.statusColor);
        }
        if (null != this.statusBgColor) {
            toChalk.apply((Ansi.AnsiCode)this.statusBgColor);
        }
        if (!this.statusModifiers.isEmpty()) {
            for (Ansi.Modifier modifier : this.statusModifiers) {
                toChalk.apply((Ansi.AnsiCode)modifier);
            }
        }
        return toChalk;
    }
}

