/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.cli.progress;

import com.github.tomaslanger.cli.progress.ProgressBar;
import java.io.PrintStream;

class ProgressBarBatch
extends ProgressBar {
    protected final boolean batchHeader;
    private int printedChars;
    private boolean isBeginStringPrinted;

    protected ProgressBarBatch(ProgressBar.Builder builder) {
        super(builder);
        this.batchHeader = builder.isBatchHeader();
    }

    @Override
    protected void printBarHeader(PrintStream out) {
        if (this.batchHeader) {
            out.print(this.beginString);
            for (int i = 0; i < this.charCount; ++i) {
                out.print(this.baseChar);
            }
            out.print(this.endString);
            out.flush();
        }
    }

    @Override
    protected void printBar(PrintStream out, int progress) {
        int shouldPrintChars = progress * this.charCount / this.max;
        if (this.printedChars == 0 && !this.isBeginStringPrinted) {
            if (this.batchHeader) {
                out.println();
            }
            out.print(this.beginString);
            this.isBeginStringPrinted = true;
            out.flush();
        }
        if (shouldPrintChars == this.printedChars) {
            return;
        }
        if (shouldPrintChars > this.printedChars) {
            for (int i = this.printedChars; i < shouldPrintChars; ++i) {
                out.print(this.chalked(this.progressChar));
            }
            out.flush();
            this.printedChars = shouldPrintChars;
        }
    }

    @Override
    protected void printBarEnd(PrintStream out) {
        out.println(this.endString);
        out.flush();
        this.printedChars = 0;
        this.isBeginStringPrinted = false;
    }

    @Override
    protected void printCancel(PrintStream out) {
        if (this.charCount > this.printedChars) {
            for (int i = this.printedChars; i < this.charCount; ++i) {
                out.print(this.baseChar);
            }
            out.println(this.endString);
            out.flush();
        }
    }
}

