/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.cli.progress;

import com.github.tomaslanger.chalk.Chalk;
import com.github.tomaslanger.cli.progress.StreamHandler;
import java.io.PrintStream;
import java.util.Map;

abstract class ProgressBarBase {
    protected static final boolean ONE_LINE_ONLY;
    protected static final boolean NO_COLOR;
    private final boolean claimStdout;
    private final boolean claimStderr;
    private boolean started;
    protected boolean iOwnOutput;
    private StreamHandler.Replace replace;

    protected ProgressBarBase(Builder builder) {
        this.claimStdout = builder.shouldClaimStdout();
        this.claimStderr = builder.shouldClaimStderr();
    }

    public final synchronized void begin() {
        if (this.started) {
            throw new IllegalStateException("Cannot start a started progress bar.");
        }
        this.replace = StreamHandler.replace(this.claimStdout, this.claimStderr, this::setOut);
        switch (this.replace) {
            case IMPOSSIBLE: {
                this.iOwnOutput = false;
                break;
            }
            case DONE: 
            case NOT_REPLACED: {
                this.iOwnOutput = true;
            }
        }
        if (this.iOwnOutput) {
            this.initProgressBar();
        }
        this.started = true;
    }

    public final synchronized void begin(PrintStream out) {
        if (this.started) {
            throw new IllegalStateException("Cannot start a started progress bar.");
        }
        this.replace = StreamHandler.Replace.NOT_REPLACED;
        this.iOwnOutput = true;
        this.setOut(out);
        this.initProgressBar();
        this.started = true;
    }

    public final synchronized void end() {
        if (!this.started) {
            return;
        }
        this.finishProgressBar(false);
        StreamHandler.replaceBack(this.replace);
        this.iOwnOutput = false;
        this.started = false;
    }

    public final void cancel() {
        if (!this.started) {
            return;
        }
        this.finishProgressBar(true);
        StreamHandler.replaceBack(this.replace);
        this.iOwnOutput = false;
        this.started = false;
    }

    protected void checkSetProgress() {
        if (!this.started) {
            this.begin();
        }
    }

    protected abstract void finishProgressBar(boolean var1);

    protected abstract void initProgressBar();

    protected abstract void setOut(PrintStream var1);

    static {
        Chalk.on((String)"init");
        ONE_LINE_ONLY = !Chalk.isCommandEnabled();
        NO_COLOR = !Chalk.isColorEnabled();
    }

    protected static class Builder<T extends Builder> {
        private boolean isBatch = Boolean.getBoolean("cliprogress.isBatch");
        private boolean claimStdout = true;
        private boolean claimStderr = true;

        protected Builder() {
            Map<String, String> env = System.getenv();
            if (env.containsKey("HUDSON_URL") || env.containsKey("JENKINS_URL")) {
                this.isBatch = true;
            }
        }

        public T claimNoOuts() {
            this.doNotClaimStderr();
            this.doNotClaimStdout();
            return (T)this;
        }

        public T setBatch() {
            this.isBatch = true;
            return (T)this;
        }

        public T doNotClaimStdout() {
            this.claimStdout = false;
            return (T)this;
        }

        public T doNotClaimStderr() {
            this.claimStderr = false;
            return (T)this;
        }

        boolean isBatch() {
            return this.isBatch;
        }

        boolean shouldClaimStdout() {
            return this.claimStdout;
        }

        boolean shouldClaimStderr() {
            return this.claimStderr;
        }
    }
}

