/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomaslanger.cli.progress;

import com.github.tomaslanger.chalk.Ansi;
import com.github.tomaslanger.chalk.Chalk;
import com.github.tomaslanger.cli.progress.ProgressBarBase;
import com.github.tomaslanger.cli.progress.ProgressBarBatch;
import com.github.tomaslanger.cli.progress.ProgressBarInPlace;
import com.github.tomaslanger.cli.progress.StatusLoc;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Set;

public abstract class ProgressBar
extends ProgressBarBase {
    protected final int charCount;
    protected final String beginString;
    protected final String endString;
    protected final char baseChar;
    protected final int max;
    protected char progressChar;
    protected Ansi.Color color;
    protected Ansi.BgColor bgColor;
    protected final Set<Ansi.Modifier> modifiers = EnumSet.noneOf(Ansi.Modifier.class);
    protected int wantedProgress;
    protected String wantedStatus;
    private PrintStream sysOut;

    protected ProgressBar(Builder builder) {
        super(builder);
        this.charCount = builder.charCount;
        this.beginString = builder.beginString;
        this.endString = builder.endString;
        this.baseChar = builder.baseChar;
        this.progressChar = builder.progressChar;
        this.color = builder.color;
        this.bgColor = builder.bgColor;
        this.modifiers.addAll(builder.modifiers);
        this.max = builder.max;
    }

    public void setProgressChar(char progressChar) {
        this.progressChar = progressChar;
    }

    public void setFgColor(Ansi.Color color) {
        this.color = color;
    }

    public void setBgColor(Ansi.BgColor color) {
        this.bgColor = color;
    }

    public void addModifier(Ansi.Modifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    protected void setOut(PrintStream out) {
        this.sysOut = out;
    }

    protected abstract void printBarHeader(PrintStream var1);

    protected Chalk chalked(String toChalk) {
        return this.chalked(Chalk.on((String)toChalk));
    }

    protected Chalk chalked(char toChalk) {
        return this.chalked(Chalk.on((String)String.valueOf(toChalk)));
    }

    private Chalk chalked(Chalk toChalk) {
        if (null != this.color) {
            toChalk.apply((Ansi.AnsiCode)this.color);
        }
        if (null != this.bgColor) {
            toChalk.apply((Ansi.AnsiCode)this.bgColor);
        }
        if (!this.modifiers.isEmpty()) {
            for (Ansi.Modifier modifier : this.modifiers) {
                toChalk.apply((Ansi.AnsiCode)modifier);
            }
        }
        return toChalk;
    }

    public synchronized void setProgress(int progress) {
        this.setProgress(progress, this.wantedStatus);
    }

    public synchronized void setStatus(String status) {
        this.setProgress(this.wantedProgress, status);
    }

    public synchronized void setProgress(int progress, String status) {
        super.checkSetProgress();
        this.wantedStatus = status;
        this.wantedProgress = progress;
        if (!this.iOwnOutput) {
            return;
        }
        if (progress > this.max) {
            this.setProgress(this.max);
        } else {
            this.printBar(this.sysOut, progress);
        }
    }

    protected abstract void printBar(PrintStream var1, int var2);

    @Override
    protected void finishProgressBar(boolean isCancel) {
        if (this.iOwnOutput) {
            if (isCancel) {
                this.printCancel(this.sysOut);
            } else {
                this.setProgress(this.max);
                this.printBarEnd(this.sysOut);
            }
        } else {
            this.printBarHeader(System.out);
            this.printBar(System.out, isCancel ? this.wantedProgress : this.max);
            this.printBarEnd(System.out);
        }
        this.wantedProgress = 0;
        this.wantedStatus = null;
    }

    @Override
    protected void initProgressBar() {
        this.printBarHeader(this.sysOut);
    }

    protected abstract void printBarEnd(PrintStream var1);

    protected abstract void printCancel(PrintStream var1);

    public int getMax() {
        return this.max;
    }

    public static class Builder
    extends ProgressBarBase.Builder<Builder> {
        private int charCount = 32;
        private String beginString = "";
        private char baseChar = (char)95;
        private String endString = "";
        private char progressChar = (char)32;
        private Ansi.Color color;
        private Ansi.BgColor bgColor = Ansi.BgColor.GREEN;
        private Set<Ansi.Modifier> modifiers = EnumSet.noneOf(Ansi.Modifier.class);
        private int max = 100;
        private boolean batchHeader = false;
        private boolean keepSingleColor = false;
        private boolean printPercents = true;
        private Ansi.Color statusColor;
        private Ansi.BgColor statusBgColor;
        private Set<Ansi.Modifier> statusModifiers = EnumSet.noneOf(Ansi.Modifier.class);
        private StatusLoc statusLocation = StatusLoc.FIRST_LINE;

        public Builder setKeepSingleColor(boolean keepSingleColor) {
            this.keepSingleColor = keepSingleColor;
            return this;
        }

        public boolean shouldKeepSingleColor() {
            return this.keepSingleColor;
        }

        public StatusLoc getStatusLocation() {
            return this.statusLocation;
        }

        public Builder setStatusLocation(StatusLoc statusLocation) {
            this.statusLocation = statusLocation;
            return this;
        }

        public Builder disablePercents() {
            this.printPercents = false;
            return this;
        }

        public boolean shouldPrintPercents() {
            return this.printPercents;
        }

        public Builder setMax(int max) {
            this.max = max;
            return this;
        }

        public Builder setBatchHeader(boolean batchHeader) {
            this.batchHeader = batchHeader;
            return this;
        }

        public Builder setCharCount(int charCount) {
            this.charCount = charCount;
            return this;
        }

        public Builder setBeginString(String beginString) {
            this.beginString = beginString;
            return this;
        }

        public Builder setBaseChar(char baseChar) {
            this.baseChar = baseChar;
            return this;
        }

        public Builder setEndString(String endString) {
            this.endString = endString;
            return this;
        }

        public Builder setProgressChar(char progressChar) {
            this.progressChar = progressChar;
            return this;
        }

        public Builder setFgColor(Ansi.Color color) {
            this.color = color;
            return this;
        }

        public Builder setBgColor(Ansi.BgColor color) {
            this.bgColor = color;
            return this;
        }

        public Builder addModifier(Ansi.Modifier modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        public Builder noColors() {
            return this.setBgColor(null).setProgressChar('*').setBaseChar('-').setStatusColor(null);
        }

        public ProgressBar build() {
            if (ProgressBarBase.NO_COLOR) {
                this.noColors();
            }
            if (ProgressBarBase.ONE_LINE_ONLY) {
                this.setStatusLocation(StatusLoc.SAME_LINE);
            }
            if (this.isBatch()) {
                return new ProgressBarBatch(this);
            }
            return new ProgressBarInPlace(this);
        }

        public boolean isBatchHeader() {
            return this.batchHeader;
        }

        public int getCharCount() {
            return this.charCount;
        }

        public String getBeginString() {
            return this.beginString;
        }

        public char getBaseChar() {
            return this.baseChar;
        }

        public String getEndString() {
            return this.endString;
        }

        public char getProgressChar() {
            return this.progressChar;
        }

        public Ansi.Color getColor() {
            return this.color;
        }

        public Ansi.BgColor getBgColor() {
            return this.bgColor;
        }

        public Set<Ansi.Modifier> getModifiers() {
            return this.modifiers;
        }

        public int getMax() {
            return this.max;
        }

        public Ansi.Color getStatusColor() {
            return this.statusColor;
        }

        public Builder setStatusColor(Ansi.Color statusColor) {
            this.statusColor = statusColor;
            return this;
        }

        public Ansi.BgColor getStatusBgColor() {
            return this.statusBgColor;
        }

        public Builder setStatusBgColor(Ansi.BgColor statusBgColor) {
            this.statusBgColor = statusBgColor;
            return this;
        }

        public void addStatusModifier(Ansi.Modifier modifier) {
            this.statusModifiers.add(modifier);
        }

        public Set<Ansi.Modifier> getStatusModifiers() {
            return this.statusModifiers;
        }

        public boolean isPrintPercents() {
            return this.printPercents;
        }

        public boolean isKeepSingleColor() {
            return this.keepSingleColor;
        }
    }
}

