/*
 * Decompiled with CFR 0.152.
 */
package com.github.tnakamot.os;

import java.util.Locale;

public class Detector {
    private static final String UNKNOWN = "unknown";

    public static String getNormalizedOSName() {
        return Detector.getNormalizedOSName(System.getProperty("os.name"));
    }

    public static String getNormalizedOSName(String string) {
        if ((string = Detector.normalize(string)).startsWith("aix")) {
            return "aix";
        }
        if (string.startsWith("hpux")) {
            return "hpux";
        }
        if (string.startsWith("os400") && (string.length() <= 5 || !Character.isDigit(string.charAt(5)))) {
            return "os400";
        }
        if (string.startsWith("linux")) {
            return "linux";
        }
        if (string.startsWith("macosx") || string.startsWith("osx")) {
            return "osx";
        }
        if (string.startsWith("freebsd")) {
            return "freebsd";
        }
        if (string.startsWith("openbsd")) {
            return "openbsd";
        }
        if (string.startsWith("netbsd")) {
            return "netbsd";
        }
        if (string.startsWith("solaris") || string.startsWith("sunos")) {
            return "sunos";
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        if (string.startsWith("zos")) {
            return "zos";
        }
        return UNKNOWN;
    }

    public static String getNormalizedArchitectureName() {
        return Detector.getNormalizedArchitectureName(System.getProperty("os.arch"));
    }

    public static String getNormalizedArchitectureName(String string) {
        if ((string = Detector.normalize(string)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (string.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (string.matches("^(ia64w?|itanium64)$")) {
            return "itanium_64";
        }
        if ("ia64n".equals(string)) {
            return "itanium_32";
        }
        if (string.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (string.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (string.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(string)) {
            return "aarch_64";
        }
        if (string.matches("^(mips|mips32)$")) {
            return "mips_32";
        }
        if (string.matches("^(mipsel|mips32el)$")) {
            return "mipsel_32";
        }
        if ("mips64".equals(string)) {
            return "mips_64";
        }
        if ("mips64el".equals(string)) {
            return "mipsel_64";
        }
        if (string.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if (string.matches("^(ppcle|ppc32le)$")) {
            return "ppcle_32";
        }
        if ("ppc64".equals(string)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(string)) {
            return "ppcle_64";
        }
        if ("s390".equals(string)) {
            return "s390_32";
        }
        if ("s390x".equals(string)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String string) {
        if (string == null) {
            return "";
        }
        return string.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }
}

