/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal;

import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.Json;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonArray;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class JsonJavadocBuilder {
    private final ProcessingEnvironment processingEnv;

    JsonJavadocBuilder(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    JsonObject getClassJavadocAsJsonOrNull(TypeElement classElement) {
        String classDoc = this.processingEnv.getElementUtils().getDocComment(classElement);
        if (RuntimeJavadocHelper.isBlank((String)classDoc)) {
            classDoc = "";
        }
        HashMap children = new HashMap();
        for (Element element : classElement.getEnclosedElements()) {
            if (!children.containsKey((Object)element.getKind())) {
                children.put(element.getKind(), new ArrayList());
            }
            ((List)children.get((Object)element.getKind())).add(element);
        }
        List emptyList = Collections.emptyList();
        List<Element> list = JsonJavadocBuilder.defaultIfNull(children.get((Object)ElementKind.FIELD), emptyList);
        List<Element> enclosedEnumConstants = JsonJavadocBuilder.defaultIfNull(children.get((Object)ElementKind.ENUM_CONSTANT), emptyList);
        List<Element> enclosedMethods = JsonJavadocBuilder.defaultIfNull(children.get((Object)ElementKind.METHOD), emptyList);
        JsonArray fieldDocs = JsonJavadocBuilder.getJavadocsAsJson(list, new FieldJavadocAsJson());
        JsonArray enumConstantDocs = JsonJavadocBuilder.getJavadocsAsJson(enclosedEnumConstants, new FieldJavadocAsJson());
        JsonArray methodDocs = JsonJavadocBuilder.getJavadocsAsJson(enclosedMethods, new MethodJavadocAsJson());
        if (RuntimeJavadocHelper.isBlank((String)classDoc) && fieldDocs.isEmpty() && enumConstantDocs.isEmpty() && methodDocs.isEmpty()) {
            return null;
        }
        JsonObject json = new JsonObject();
        json.add(RuntimeJavadocHelper.elementDocFieldName(), classDoc);
        json.add(RuntimeJavadocHelper.fieldsFieldName(), fieldDocs);
        json.add(RuntimeJavadocHelper.enumConstantsFieldName(), enumConstantDocs);
        json.add(RuntimeJavadocHelper.methodsFieldName(), methodDocs);
        return json;
    }

    private static JsonArray getJavadocsAsJson(List<Element> elements, ElementToJsonFunction createDoc) {
        JsonArray jsonArray = new JsonArray();
        for (Element e : elements) {
            JsonObject eMapped = createDoc.apply(e);
            if (eMapped == null) continue;
            jsonArray.add(eMapped);
        }
        return jsonArray;
    }

    private JsonArray getParamErasures(ExecutableElement executableElement) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        JsonArray jsonValues = new JsonArray();
        for (VariableElement variableElement : executableElement.getParameters()) {
            TypeMirror erasure = typeUtils.erasure(variableElement.asType());
            jsonValues.add(Json.value(erasure.toString()));
        }
        return jsonValues;
    }

    private static <T> T defaultIfNull(T actualValue, T defaultValue) {
        return actualValue != null ? actualValue : defaultValue;
    }

    private class MethodJavadocAsJson
    implements ElementToJsonFunction {
        private MethodJavadocAsJson() {
        }

        @Override
        public JsonObject apply(Element method) {
            assert (method instanceof ExecutableElement);
            String methodJavadoc = JsonJavadocBuilder.this.processingEnv.getElementUtils().getDocComment(method);
            if (RuntimeJavadocHelper.isBlank((String)methodJavadoc)) {
                return null;
            }
            JsonObject jsonDoc = new JsonObject();
            jsonDoc.add(RuntimeJavadocHelper.elementNameFieldName(), method.getSimpleName().toString());
            jsonDoc.add(RuntimeJavadocHelper.paramTypesFieldName(), JsonJavadocBuilder.this.getParamErasures((ExecutableElement)method));
            jsonDoc.add(RuntimeJavadocHelper.elementDocFieldName(), methodJavadoc);
            return jsonDoc;
        }
    }

    private class FieldJavadocAsJson
    implements ElementToJsonFunction {
        private FieldJavadocAsJson() {
        }

        @Override
        public JsonObject apply(Element field) {
            String javadoc = JsonJavadocBuilder.this.processingEnv.getElementUtils().getDocComment(field);
            if (RuntimeJavadocHelper.isBlank((String)javadoc)) {
                return null;
            }
            JsonObject jsonDoc = new JsonObject();
            jsonDoc.add(RuntimeJavadocHelper.elementNameFieldName(), field.getSimpleName().toString());
            jsonDoc.add(RuntimeJavadocHelper.elementDocFieldName(), javadoc);
            return jsonDoc;
        }
    }

    private static interface ElementToJsonFunction {
        public JsonObject apply(Element var1);
    }
}

