/*
 * Decompiled with CFR 0.152.
 */
package com.github.taymindis;

import com.github.taymindis.OJHAlertable;
import com.github.taymindis.OJHSynchronizeRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OJHSynchronizeProcess
extends OJHSynchronizeRequest {
    private static Thread notificationThreads;
    private static Map<String, OJHSynchronizeProcess> processNamesLiving;
    private Thread processThread;
    private Long rollingTime;
    private boolean alertable;
    private OJHAlertable OJHAlertable;
    private static boolean isProcessOn;

    public OJHSynchronizeProcess(String name, OJHAlertable OJHAlertable_) {
        super(name);
        int errCode = this.getErrorCode();
        this.OJHAlertable = OJHAlertable_;
        this.alertable = this.OJHAlertable.shouldAlert();
        if (errCode != 1) {
            String log = name + " process is still running or invalid process ";
            this.OJHAlertable.logInfo(log);
        } else {
            if (notificationThreads == null || notificationThreads.isInterrupted() || !notificationThreads.isAlive()) {
                notificationThreads = OJHSynchronizeProcess.newThread();
                notificationThreads.start();
            }
            this.processThread = Thread.currentThread();
            this.rollingTime = new Date().getTime();
            processNamesLiving.put(name, this);
        }
    }

    @Override
    public void release() {
        if (this.getProcessStatus() == 1) {
            processNamesLiving.remove(this.getName());
        }
        super.release();
    }

    public static void releaseAllProcess() {
        for (Map.Entry<String, OJHSynchronizeProcess> pLiving : processNamesLiving.entrySet()) {
            OJHSynchronizeProcess thisProcess = pLiving.getValue();
            thisProcess.release();
        }
    }

    public Thread getProcessThread() {
        return this.processThread;
    }

    public Long getRollingTime() {
        return this.rollingTime;
    }

    public void setRollingTime(Long rollingTime) {
        this.rollingTime = rollingTime;
    }

    public static void kill(String processName) {
        OJHSynchronizeProcess syncTrackableProcess = processNamesLiving.get(processName);
        if (syncTrackableProcess != null) {
            syncTrackableProcess.getProcessThread().interrupt();
            syncTrackableProcess.release();
        }
    }

    private static Thread newThread() {
        return new Thread(){

            @Override
            public void run() {
                try {
                    while (isProcessOn) {
                        Long currTime = new Date().getTime();
                        for (Map.Entry entry : processNamesLiving.entrySet()) {
                            OJHSynchronizeProcess thisProcess = (OJHSynchronizeProcess)entry.getValue();
                            if (!thisProcess.alertable) continue;
                            Long startedTime = thisProcess.getRollingTime();
                            Long secs = (currTime - startedTime) / 1000L;
                            if (secs <= 300L) continue;
                            thisProcess.OJHAlertable.triggerAlert(thisProcess.getName(), "Processing time out");
                            thisProcess.setRollingTime(currTime);
                            entry.setValue(thisProcess);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static void setIsProcessOn(boolean isProcessOn) {
        OJHSynchronizeProcess.isProcessOn = isProcessOn;
    }

    static {
        processNamesLiving = new HashMap<String, OJHSynchronizeProcess>();
        isProcessOn = true;
        notificationThreads = OJHSynchronizeProcess.newThread();
        notificationThreads.start();
    }
}

