/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.ext;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.StringUtility;

public class MybatisPlusPlugin
extends BasePlugin {
    private ShellCallback shellCallback;
    private JavaFormatter javaFormatter;
    private String modelTargetPackage;
    private String modelTargetProject;
    private String clientTargetPackage;
    private String clientTargetProject;
    private String baseMapper;
    private String tableName;
    private String tableIdType;
    private String keySequence;
    private String swagger = "false";
    private String generatedController = "false";
    private String constructorTargetPackage;
    private String serviceStyle = "simple";
    private String generatedService = "false";
    private String generatedSqlMap = "true";
    private String generatedResultMap = "false";
    private String serviceTargetPackage;
    private String sqlMapTargetPackage;
    private String sqlMapTargetProject;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.shellCallback = new DefaultShellCallback(false);
        this.javaFormatter = this.context.getJavaFormatter();
        this.baseMapper = this.getProperties().getProperty("baseMapper");
        this.tableName = this.getProperties().getProperty("tableName");
        this.tableIdType = this.getProperties().getProperty("tableIdType");
        this.generatedResultMap = this.getProperties().getProperty("generatedResultMap");
        this.keySequence = introspectedTable.getTableConfigurationProperty("keySequence");
        this.constructorTargetPackage = this.getProperties().getProperty("constructorTargetPackage");
        this.serviceTargetPackage = this.getProperties().getProperty("serviceTargetPackage");
        this.serviceStyle = this.getProperties().getProperty("serviceStyle");
        this.generatedController = introspectedTable.getTableConfigurationProperty("generatedController");
        this.generatedService = introspectedTable.getTableConfigurationProperty("generatedService");
        this.generatedSqlMap = introspectedTable.getTableConfigurationProperty("generatedSqlMap");
        JavaModelGeneratorConfiguration javaModelGenCfg = this.context.getJavaModelGeneratorConfiguration();
        this.modelTargetPackage = javaModelGenCfg.getTargetPackage();
        this.modelTargetProject = javaModelGenCfg.getTargetProject();
        JavaClientGeneratorConfiguration javaCliGenCfg = this.context.getJavaClientGeneratorConfiguration();
        this.clientTargetProject = javaCliGenCfg.getTargetProject();
        this.clientTargetPackage = javaCliGenCfg.getTargetPackage();
        SqlMapGeneratorConfiguration sqlMapGenCfg = this.context.getSqlMapGeneratorConfiguration();
        this.sqlMapTargetProject = sqlMapGenCfg.getTargetProject();
        this.sqlMapTargetPackage = sqlMapGenCfg.getTargetPackage();
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generatePlus(topLevelClass, introspectedTable);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    private void generatePlus(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List primaryKeyColumns = introspectedTable.getPrimaryKeyColumns();
        if (primaryKeyColumns.size() == 1) {
            IntrospectedColumn introspectedColumn = (IntrospectedColumn)primaryKeyColumns.get(0);
            if (StringUtility.stringHasValue((String)this.tableIdType)) {
                topLevelClass.addImportedType("com.baomidou.mybatisplus.annotation.IdType");
            }
            topLevelClass.addImportedType("com.baomidou.mybatisplus.annotation.TableId");
            List fields = topLevelClass.getFields();
            for (Field field : fields) {
                if (!field.getName().equals(introspectedColumn.getJavaProperty())) continue;
                if (StringUtility.stringHasValue((String)this.tableIdType)) {
                    field.addAnnotation(String.format("@TableId(type = IdType.%s)", this.tableIdType));
                    continue;
                }
                field.addAnnotation("@TableId");
            }
        }
        if ("true".equals(this.tableName)) {
            topLevelClass.addImportedType("com.baomidou.mybatisplus.annotation.TableName");
            topLevelClass.addAnnotation(String.format("@TableName(value = \"%s\")", introspectedTable.getFullyQualifiedTable().getIntrospectedTableName()));
        }
        if (StringUtility.stringHasValue((String)this.keySequence)) {
            topLevelClass.addImportedType("com.baomidou.mybatisplus.annotation.KeySequence");
            topLevelClass.addAnnotation(String.format("@KeySequence(value = \"%s\")", this.keySequence));
        }
    }

    public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
        return StringUtility.stringHasValue((String)this.generatedService) && !"false".equals(this.generatedService);
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        GeneratedJavaFile javaFile = new GeneratedJavaFile((CompilationUnit)interfaze, this.clientTargetProject, this.javaFormatter);
        javaFile.isMergeable();
        FullyQualifiedTable fullyQualifiedTable = introspectedTable.getFullyQualifiedTable();
        FullyQualifiedJavaType daoSuperType = new FullyQualifiedJavaType(this.baseMapper);
        FullyQualifiedJavaType modelJavaType = this.getModelJavaType(fullyQualifiedTable);
        interfaze.addImportedType(daoSuperType);
        interfaze.addImportedType(modelJavaType);
        daoSuperType.addTypeArgument(modelJavaType);
        interfaze.addSuperInterface(new FullyQualifiedJavaType(daoSuperType.getShortName()));
        List primaryKeyColumns = introspectedTable.getPrimaryKeyColumns();
        IntrospectedColumn primaryKeyColumn = (IntrospectedColumn)primaryKeyColumns.get(0);
        String tableName = introspectedTable.getFullyQualifiedTable().getIntrospectedTableName();
        List allColumns = introspectedTable.getAllColumns();
        Method method = new Method("select" + modelJavaType.getShortName());
        String selectStr = "@Select(\"select * from " + tableName + " where " + primaryKeyColumn.getActualColumnName() + " = #{" + primaryKeyColumn.getJavaProperty() + "}\")";
        String methodStr = modelJavaType.getShortName() + " " + method.getName();
        StringBuilder resultsCode = new StringBuilder();
        if ("true".equals(this.generatedResultMap)) {
            resultsCode.append("@Results(id = \"BaseResultMap\"").append(", value = {\n");
            for (IntrospectedColumn column : allColumns) {
                String javaProperty = column.getJavaProperty();
                String actualColumnName = column.getActualColumnName();
                resultsCode.append("        @Result(property = \"").append(javaProperty).append("\", column = \"").append(actualColumnName).append("\"),\n");
            }
            resultsCode.append("    })");
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Result"));
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Results"));
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Select"));
            method.setReturnType(modelJavaType);
            method.addParameter(new Parameter(primaryKeyColumn.getFullyQualifiedJavaType(), primaryKeyColumn.getJavaProperty()));
            method.addAnnotation(selectStr);
            method.addAnnotation(resultsCode.toString());
            interfaze.addMethod(method);
        }
        if (this.fileExists(javaFile)) {
            try {
                if ("true".equals(this.generatedResultMap)) {
                    File fileDir = this.shellCallback.getDirectory(javaFile.getTargetProject(), javaFile.getTargetPackage());
                    File file = new File(fileDir, javaFile.getFileName());
                    String fileContent = this.readFileContent(file);
                    int start = fileContent.indexOf(selectStr);
                    if (start > 0) {
                        start += selectStr.length();
                    }
                    int end = fileContent.indexOf(methodStr);
                    resultsCode.insert(0, "\n    ");
                    resultsCode.append("\n    ");
                    if (start > 0 && end > 0) {
                        String oldContent = fileContent.substring(start, end);
                        String newFileContent = fileContent.replace(oldContent, resultsCode.toString());
                        this.writeFileContent(file, newFileContent);
                    }
                }
            }
            catch (Exception e) {
                logger.info("\u5f02\u5e38", (Throwable)e);
            }
            return false;
        }
        return super.clientGenerated(interfaze, topLevelClass, introspectedTable);
    }

    private String readFileContent(File file) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        if (content.length() > 0) {
            content.deleteCharAt(content.length() - 1);
        }
        return content.toString();
    }

    private void writeFileContent(File file, String content) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }

    private FullyQualifiedJavaType getModelJavaType(FullyQualifiedTable fullyQualifiedTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.modelTargetPackage);
        sb.append('.');
        if (StringUtility.stringHasValue((String)fullyQualifiedTable.getDomainObjectSubPackage())) {
            sb.append(fullyQualifiedTable.getDomainObjectSubPackage());
            sb.append('.');
        }
        sb.append(fullyQualifiedTable.getDomainObjectName());
        return new FullyQualifiedJavaType(sb.toString());
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        ArrayList<GeneratedJavaFile> generatedJavaFiles = new ArrayList<GeneratedJavaFile>();
        FullyQualifiedJavaType modelJavaType = this.getModelJavaType(introspectedTable.getFullyQualifiedTable());
        List javaFiles = introspectedTable.getGeneratedJavaFiles();
        for (GeneratedJavaFile javaFile : javaFiles) {
            GeneratedJavaFile serviceImpl;
            GeneratedJavaFile controller;
            CompilationUnit unit = javaFile.getCompilationUnit();
            FullyQualifiedJavaType baseModelJavaType = unit.getType();
            if (!modelJavaType.getFullyQualifiedName().equals(baseModelJavaType.getFullyQualifiedName())) continue;
            String shortName = baseModelJavaType.getFullyQualifiedName().replace(this.modelTargetPackage, "");
            if (StringUtility.stringHasValue((String)this.generatedController) && !"false".equals(this.generatedController) && !this.fileExists(controller = this.generatedController(baseModelJavaType, shortName))) {
                generatedJavaFiles.add(controller);
            }
            if (!StringUtility.stringHasValue((String)this.generatedService) || "false".equals(this.generatedService)) continue;
            if ("simple".equals(this.serviceStyle)) {
                GeneratedJavaFile simpleService = this.generatedSimpleService(baseModelJavaType, shortName);
                if (this.fileExists(simpleService)) continue;
                generatedJavaFiles.add(simpleService);
                continue;
            }
            GeneratedJavaFile service = this.generatedService(baseModelJavaType, shortName);
            if (!this.fileExists(service)) {
                generatedJavaFiles.add(service);
            }
            if (this.fileExists(serviceImpl = this.generatedServiceImpl(service))) continue;
            generatedJavaFiles.add(serviceImpl);
        }
        return generatedJavaFiles;
    }

    private boolean fileExists(GeneratedJavaFile javaFile) {
        try {
            File fileDir = this.shellCallback.getDirectory(javaFile.getTargetProject(), javaFile.getTargetPackage());
            File file = new File(fileDir, javaFile.getFileName());
            return file.exists();
        }
        catch (ShellException e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
            return true;
        }
    }

    private GeneratedJavaFile generatedService(FullyQualifiedJavaType baseModelJavaType, String shortName) {
        String name = StringUtility.isTrue((String)this.generatedService) ? shortName + "Service" : "." + this.generatedService;
        Interface anInterface = new Interface(this.serviceTargetPackage + name);
        anInterface.setVisibility(JavaVisibility.PUBLIC);
        return new GeneratedJavaFile((CompilationUnit)anInterface, this.modelTargetProject, this.javaFormatter);
    }

    private GeneratedJavaFile generatedServiceImpl(GeneratedJavaFile JavaFile) {
        FullyQualifiedJavaType serviceType = JavaFile.getCompilationUnit().getType();
        TopLevelClass topLevelClass = new TopLevelClass(serviceType.getPackageName() + ".impl." + serviceType.getShortName() + "Impl");
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.addImportedType(new FullyQualifiedJavaType("lombok.extern.slf4j.Slf4j"));
        topLevelClass.addAnnotation("@Slf4j");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("lombok.RequiredArgsConstructor"));
        topLevelClass.addAnnotation("@RequiredArgsConstructor");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Service"));
        topLevelClass.addAnnotation("@Service");
        topLevelClass.addImportedType(serviceType);
        topLevelClass.addSuperInterface(new FullyQualifiedJavaType(serviceType.getShortName()));
        return new GeneratedJavaFile((CompilationUnit)topLevelClass, this.modelTargetProject, this.javaFormatter);
    }

    private GeneratedJavaFile generatedSimpleService(FullyQualifiedJavaType baseModelJavaType, String shortName) {
        String name = StringUtility.isTrue((String)this.generatedService) ? shortName + "Service" : "." + this.generatedService;
        TopLevelClass topLevelClass = new TopLevelClass(this.serviceTargetPackage + name);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.addImportedType(new FullyQualifiedJavaType("lombok.extern.slf4j.Slf4j"));
        topLevelClass.addAnnotation("@Slf4j");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("lombok.RequiredArgsConstructor"));
        topLevelClass.addAnnotation("@RequiredArgsConstructor");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Service"));
        topLevelClass.addAnnotation("@Service");
        return new GeneratedJavaFile((CompilationUnit)topLevelClass, this.modelTargetProject, this.javaFormatter);
    }

    private GeneratedJavaFile generatedController(FullyQualifiedJavaType baseModelJavaType, String shortName) {
        String name = StringUtility.isTrue((String)this.generatedController) ? shortName + "Controller" : "." + this.generatedController;
        TopLevelClass topLevelClass = new TopLevelClass(this.constructorTargetPackage + name);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.addImportedType(new FullyQualifiedJavaType("lombok.extern.slf4j.Slf4j"));
        topLevelClass.addAnnotation("@Slf4j");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("lombok.RequiredArgsConstructor"));
        topLevelClass.addAnnotation("@RequiredArgsConstructor");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.springframework.web.bind.annotation.RestController"));
        topLevelClass.addAnnotation("@RestController");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.springframework.web.bind.annotation.RequestMapping"));
        topLevelClass.addAnnotation(String.format("@RequestMapping(\"%s\")", "/"));
        return new GeneratedJavaFile((CompilationUnit)topLevelClass, this.modelTargetProject, this.javaFormatter);
    }

    private GeneratedJavaFile generatedMapper(String mapperName, FullyQualifiedJavaType baseModelJavaType, String shortName) {
        Interface anInterface = StringUtility.stringHasValue((String)mapperName) ? new Interface(this.clientTargetPackage + "." + mapperName) : new Interface(this.clientTargetPackage + shortName + "Mapper");
        anInterface.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType daoSuperType = new FullyQualifiedJavaType(this.baseMapper);
        anInterface.addImportedType(baseModelJavaType);
        anInterface.addImportedType(daoSuperType);
        daoSuperType.addTypeArgument(baseModelJavaType);
        anInterface.addSuperInterface(new FullyQualifiedJavaType(daoSuperType.getShortName()));
        return new GeneratedJavaFile((CompilationUnit)anInterface, this.modelTargetProject, this.javaFormatter);
    }

    public boolean clientBasicCountMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientBasicDeleteMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientBasicInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientBasicSelectManyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientBasicSelectOneMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientBasicUpdateMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientCountByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientCountByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientInsertMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean clientSelectAllMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return super.clientSelectAllMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientSelectAllMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapCountByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapDeleteByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapDeleteByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapExampleWhereClauseElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapInsertSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapSelectAllElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }
}

