/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.ext;

import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTypeResolverSolver
extends JavaTypeResolverDefaultImpl {
    protected static final Logger logger = LoggerFactory.getLogger(MyTypeResolverSolver.class);
    public static final String MAPPER_INTEGER_TYPE = "mapper_integer_type";
    public static final String MAPPER_LONG_TYPE = "mapper_long_type";
    public static final String MAPPER_INTEGER_REGEX = "mapper_integer_regex";
    public static final String MAPPER_LONG_REGEX = "mapper_long_regex";

    protected FullyQualifiedJavaType overrideDefaultType(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        logger.info("overrideDefaultType --> {}", (Object)column.toString());
        return super.overrideDefaultType(column, defaultType);
    }

    protected FullyQualifiedJavaType calculateBigDecimalReplacement(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        String pattern;
        String typeStr;
        FullyQualifiedJavaType answer = super.calculateBigDecimalReplacement(column, defaultType);
        String tls = column.getJdbcType() + "/" + column.getLength() + "/" + column.getScale();
        if (this.properties.containsKey(MAPPER_INTEGER_TYPE) && (typeStr = this.properties.getProperty(MAPPER_INTEGER_TYPE)).contains(tls)) {
            answer = new FullyQualifiedJavaType("java.lang.Integer");
        }
        if (this.properties.containsKey(MAPPER_LONG_TYPE) && (typeStr = this.properties.getProperty(MAPPER_LONG_TYPE)).contains(tls)) {
            answer = new FullyQualifiedJavaType("java.lang.Long");
        }
        if (this.properties.containsKey(MAPPER_INTEGER_REGEX) && Pattern.matches(pattern = this.properties.getProperty(MAPPER_INTEGER_REGEX), column.getActualColumnName())) {
            answer = new FullyQualifiedJavaType("java.lang.Integer");
        }
        if (this.properties.containsKey(MAPPER_LONG_REGEX) && Pattern.matches(pattern = this.properties.getProperty(MAPPER_LONG_REGEX), column.getActualColumnName())) {
            answer = new FullyQualifiedJavaType("java.lang.Long");
        }
        return answer;
    }
}

