/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.IModelColumnPluginHook;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;

public class ModelColumnPlugin
extends BasePlugin {
    public static final String ENUM_NAME = "Column";
    public static final String METHOD_EXCLUDES = "excludes";
    public static final String METHOD_ALL = "all";
    public static final String METHOD_GET_ESCAPED_COLUMN_NAME = "getEscapedColumnName";
    public static final String METHOD_GET_ALIASED_ESCAPED_COLUMN_NAME = "getAliasedEscapedColumnName";
    public static final String CONST_BEGINNING_DELIMITER = "BEGINNING_DELIMITER";
    public static final String CONST_ENDING_DELIMITER = "ENDING_DELIMITER";

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addInnerEnum(this.generateColumnEnum(topLevelClass, introspectedTable));
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addInnerEnum(this.generateColumnEnum(topLevelClass, introspectedTable));
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addInnerEnum(this.generateColumnEnum(topLevelClass, introspectedTable));
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    private InnerEnum generateColumnEnum(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerEnum innerEnum = new InnerEnum(new FullyQualifiedJavaType(ENUM_NAME));
        innerEnum.setVisibility(JavaVisibility.PUBLIC);
        innerEnum.setStatic(true);
        this.commentGenerator.addEnumComment(innerEnum, introspectedTable);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u5185\u90e8Builder\u7c7b\u3002");
        Field beginningDelimiterField = JavaElementGeneratorTools.generateField(CONST_BEGINNING_DELIMITER, JavaVisibility.PRIVATE, FullyQualifiedJavaType.getStringInstance(), "\"" + StringUtility.escapeStringForJava((String)this.context.getBeginningDelimiter()) + "\"");
        beginningDelimiterField.setStatic(true);
        beginningDelimiterField.setFinal(true);
        this.commentGenerator.addFieldComment(beginningDelimiterField, introspectedTable);
        innerEnum.addField(beginningDelimiterField);
        Field endingDelimiterField = JavaElementGeneratorTools.generateField(CONST_ENDING_DELIMITER, JavaVisibility.PRIVATE, FullyQualifiedJavaType.getStringInstance(), "\"" + StringUtility.escapeStringForJava((String)this.context.getEndingDelimiter()) + "\"");
        endingDelimiterField.setStatic(true);
        endingDelimiterField.setFinal(true);
        this.commentGenerator.addFieldComment(endingDelimiterField, introspectedTable);
        innerEnum.addField(endingDelimiterField);
        Field columnField = new Field("column", FullyQualifiedJavaType.getStringInstance());
        columnField.setVisibility(JavaVisibility.PRIVATE);
        columnField.setFinal(true);
        this.commentGenerator.addFieldComment(columnField, introspectedTable);
        innerEnum.addField(columnField);
        Field isColumnNameDelimitedField = new Field("isColumnNameDelimited", FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        isColumnNameDelimitedField.setVisibility(JavaVisibility.PRIVATE);
        isColumnNameDelimitedField.setFinal(true);
        this.commentGenerator.addFieldComment(isColumnNameDelimitedField, introspectedTable);
        innerEnum.addField(isColumnNameDelimitedField);
        Field javaPropertyField = new Field("javaProperty", FullyQualifiedJavaType.getStringInstance());
        javaPropertyField.setVisibility(JavaVisibility.PRIVATE);
        javaPropertyField.setFinal(true);
        this.commentGenerator.addFieldComment(javaPropertyField, introspectedTable);
        innerEnum.addField(javaPropertyField);
        Field jdbcTypeField = new Field("jdbcType", FullyQualifiedJavaType.getStringInstance());
        jdbcTypeField.setVisibility(JavaVisibility.PRIVATE);
        jdbcTypeField.setFinal(true);
        this.commentGenerator.addFieldComment(jdbcTypeField, introspectedTable);
        innerEnum.addField(jdbcTypeField);
        Method mValue = new Method("value");
        mValue.setVisibility(JavaVisibility.PUBLIC);
        mValue.setReturnType(FullyQualifiedJavaType.getStringInstance());
        mValue.addBodyLine("return this.column;");
        this.commentGenerator.addGeneralMethodComment(mValue, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mValue);
        Method mGetValue = new Method("getValue");
        mGetValue.setVisibility(JavaVisibility.PUBLIC);
        mGetValue.setReturnType(FullyQualifiedJavaType.getStringInstance());
        mGetValue.addBodyLine("return this.column;");
        this.commentGenerator.addGeneralMethodComment(mGetValue, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mGetValue);
        Method mGetJavaProperty = JavaElementGeneratorTools.generateGetterMethod(javaPropertyField);
        this.commentGenerator.addGeneralMethodComment(mGetJavaProperty, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mGetJavaProperty);
        Method mGetJdbcType = JavaElementGeneratorTools.generateGetterMethod(jdbcTypeField);
        this.commentGenerator.addGeneralMethodComment(mGetJdbcType, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mGetJdbcType);
        Method constructor = new Method(ENUM_NAME);
        constructor.setConstructor(true);
        constructor.addBodyLine("this.column = column;");
        constructor.addBodyLine("this.javaProperty = javaProperty;");
        constructor.addBodyLine("this.jdbcType = jdbcType;");
        constructor.addBodyLine("this.isColumnNameDelimited = isColumnNameDelimited;");
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "column"));
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "javaProperty"));
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "jdbcType"));
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "isColumnNameDelimited"));
        this.commentGenerator.addGeneralMethodComment(constructor, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, constructor);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0\u6784\u9020\u65b9\u6cd5\u548ccolumn\u5c5e\u6027\u3002");
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            Field field = JavaBeansUtil.getJavaBeansField((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            StringBuffer sb = new StringBuffer();
            sb.append(field.getName());
            sb.append("(\"");
            sb.append(introspectedColumn.getActualColumnName());
            sb.append("\", \"");
            sb.append(introspectedColumn.getJavaProperty());
            sb.append("\", \"");
            sb.append(introspectedColumn.getJdbcTypeName());
            sb.append("\", ");
            sb.append(introspectedColumn.isColumnNameDelimited());
            sb.append(")");
            innerEnum.addEnumConstant(sb.toString());
            logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0" + field.getName() + "\u679a\u4e3e\u3002");
        }
        Method desc = new Method("desc");
        desc.setVisibility(JavaVisibility.PUBLIC);
        desc.setReturnType(FullyQualifiedJavaType.getStringInstance());
        desc.addBodyLine("return this.getEscapedColumnName() + \" DESC\";");
        this.commentGenerator.addGeneralMethodComment(desc, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, desc);
        Method asc = new Method("asc");
        asc.setVisibility(JavaVisibility.PUBLIC);
        asc.setReturnType(FullyQualifiedJavaType.getStringInstance());
        asc.addBodyLine("return this.getEscapedColumnName() + \" ASC\";");
        this.commentGenerator.addGeneralMethodComment(asc, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, asc);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0asc()\u548cdesc()\u65b9\u6cd5\u3002");
        topLevelClass.addImportedType("java.util.Arrays");
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewArrayListInstance());
        Method mExcludes = JavaElementGeneratorTools.generateMethod(METHOD_EXCLUDES, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("Column[]"), new Parameter(innerEnum.getType(), METHOD_EXCLUDES, true));
        this.commentGenerator.addGeneralMethodComment(mExcludes, introspectedTable);
        mExcludes.setStatic(true);
        JavaElementGeneratorTools.generateMethodBody(mExcludes, "ArrayList<Column> columns = new ArrayList<>(Arrays.asList(Column.values()));", "if (excludes != null && excludes.length > 0) {", "columns.removeAll(new ArrayList<>(Arrays.asList(excludes)));", "}", "return columns.toArray(new Column[]{});");
        FormatTools.addMethodWithBestPosition(innerEnum, mExcludes);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0excludes\u65b9\u6cd5\u3002");
        Method mAll = JavaElementGeneratorTools.generateMethod(METHOD_ALL, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("Column[]"), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(mAll, introspectedTable);
        mAll.setStatic(true);
        mAll.addBodyLine("return Column.values();");
        FormatTools.addMethodWithBestPosition(innerEnum, mAll);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0all\u65b9\u6cd5\u3002");
        Method mGetEscapedColumnName = JavaElementGeneratorTools.generateMethod(METHOD_GET_ESCAPED_COLUMN_NAME, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getStringInstance(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(mGetEscapedColumnName, introspectedTable);
        JavaElementGeneratorTools.generateMethodBody(mGetEscapedColumnName, "if (this.isColumnNameDelimited) {", "return new StringBuilder().append(BEGINNING_DELIMITER).append(this.column).append(ENDING_DELIMITER).toString();", "} else {", "return this.column;", "}");
        FormatTools.addMethodWithBestPosition(innerEnum, mGetEscapedColumnName);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0getEscapedColumnName\u65b9\u6cd5\u3002");
        Method mGetAliasedEscapedColumnName = JavaElementGeneratorTools.generateMethod(METHOD_GET_ALIASED_ESCAPED_COLUMN_NAME, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getStringInstance(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(mGetAliasedEscapedColumnName, introspectedTable);
        if (StringUtility.stringHasValue((String)introspectedTable.getTableConfiguration().getAlias())) {
            String alias = introspectedTable.getTableConfiguration().getAlias();
            mGetAliasedEscapedColumnName.addBodyLine("StringBuilder sb = new StringBuilder();");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(\"" + alias + ".\");");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(this.getEscapedColumnName());");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(\" as \");");
            mGetAliasedEscapedColumnName.addBodyLine("if (this.isColumnNameDelimited) {");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(BEGINNING_DELIMITER);");
            mGetAliasedEscapedColumnName.addBodyLine("}");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(\"" + alias + "_\");");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(this.column);");
            mGetAliasedEscapedColumnName.addBodyLine("if (this.isColumnNameDelimited) {");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(BEGINNING_DELIMITER);");
            mGetAliasedEscapedColumnName.addBodyLine("}");
            mGetAliasedEscapedColumnName.addBodyLine("return sb.toString();");
        } else {
            mGetAliasedEscapedColumnName.addBodyLine("return this.getEscapedColumnName();");
        }
        FormatTools.addMethodWithBestPosition(innerEnum, mGetAliasedEscapedColumnName);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0getAliasedEscapedColumnName\u65b9\u6cd5\u3002");
        PluginTools.getHook(IModelColumnPluginHook.class).modelColumnEnumGenerated(innerEnum, topLevelClass, introspectedTable);
        return innerEnum;
    }
}

