/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.ext;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import java.math.BigDecimal;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class ValidPlugin
extends BasePlugin {
    private String dbType;
    private String validMessage;
    private String validLength;
    private String validDigits;
    private String validByteLength;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.validMessage = this.getProperties().getProperty("valid_message");
        this.validLength = this.getProperties().getProperty("valid_length");
        this.validDigits = this.getProperties().getProperty("valid_digits");
        this.validByteLength = this.getProperties().getProperty("valid_byte_length");
        if (this.getContext().getJdbcConnectionConfiguration().getDriverClass().contains("mysql")) {
            this.dbType = "mysql";
        } else if (this.getContext().getJdbcConnectionConfiguration().getDriverClass().contains("oracle")) {
            this.dbType = "oracle";
        } else if (this.getContext().getJdbcConnectionConfiguration().getDriverClass().contains("postgresql")) {
            this.dbType = "postgresql";
        }
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generatePlus(topLevelClass, introspectedTable);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    private void generatePlus(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List fields = topLevelClass.getFields();
        List allColumn = introspectedTable.getAllColumns();
        for (IntrospectedColumn column : allColumn) {
            int length;
            int jdbcType = column.getJdbcType();
            String javaProperty = column.getJavaProperty();
            Field field = this.filterField(fields, javaProperty);
            if (field == null) continue;
            FullyQualifiedJavaType fullyQualifiedJavaType = column.getFullyQualifiedJavaType();
            String typeName = fullyQualifiedJavaType.getFullyQualifiedName();
            String msg = "";
            if (StringUtility.stringHasValue((String)this.validMessage)) {
                msg = String.format(", message = \"%s\"", this.validMessage);
            }
            if (column.isStringColumn()) {
                length = column.getLength();
                if ("oracle".equals(this.dbType)) {
                    if (2011 == jdbcType || -9 == jdbcType || -15 == jdbcType) {
                        topLevelClass.addImportedType(this.validByteLength);
                        field.addAnnotation(String.format("@ByteLength(max = %s, charset = \"UTF-8\"%s)", length, msg));
                    } else {
                        topLevelClass.addImportedType(this.validByteLength);
                        field.addAnnotation(String.format("@ByteLength(max = %s%s)", length, msg));
                    }
                } else {
                    topLevelClass.addImportedType(this.validLength);
                    field.addAnnotation(String.format("@Length(max = %s%s)", length, msg));
                }
            }
            if (typeName.equals(Integer.class.getName()) || typeName.equals(Long.class.getName()) || typeName.equals(Short.class.getName())) {
                length = column.getLength();
                topLevelClass.addImportedType(this.validDigits);
                field.addAnnotation(String.format("@Digits(integer = %s, fraction = 0%s)", length, msg));
                continue;
            }
            if (!typeName.equals(BigDecimal.class.getName()) && !typeName.equals(Double.class.getName()) && !typeName.equals(Float.class.getName())) continue;
            length = column.getLength();
            int scale = column.getScale();
            topLevelClass.addImportedType(this.validDigits);
            field.addAnnotation(String.format("@Digits(integer = %s, fraction = %s%s)", length, scale, msg));
        }
    }

    private Field filterField(List<Field> fields, String javaProperty) {
        for (Field field : fields) {
            if (!field.getName().equals(javaProperty)) continue;
            return field;
        }
        return null;
    }
}

